package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconRule;
import com.xforceplus.reconciliationbill.service.IReconRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReconRuleController {

  @Autowired
  private IReconRuleService reconRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconRule ${table.comment}
   * @return
   */
  @GetMapping("/reconrules" )
  public XfR getReconRules(XfPage page, ReconRule reconRule) {
    return XfR.ok(reconRuleServiceImpl.page(page, Wrappers.query(reconRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconrules")
  public XfR save(@RequestBody ReconRule reconRule) {
     return XfR.ok(reconRuleServiceImpl.save(reconRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconrules/{id}")
  public XfR putUpdate(@RequestBody ReconRule reconRule,@PathVariable Long id) {
      reconRule.setId(id);
      return XfR.ok(reconRuleServiceImpl.updateById(reconRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconrules/{id}")
  public XfR patchUpdate(@RequestBody ReconRule reconRule,@PathVariable Long id) {
      ReconRule upreconRule = reconRuleServiceImpl.getById(id);
      if(upreconRule != null){
        upreconRule = ObjectCopyUtils.copyProperties(reconRule,upreconRule,true);
      }
      return XfR.ok(reconRuleServiceImpl.updateById(upreconRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconRuleServiceImpl.removeById(id));
  }

  @PostMapping("/reconrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconrule");
      params.put("request", condition);

     return XfR.ok(reconRuleServiceImpl.querys(params));
  }

}
