package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconRuleItem;
import com.xforceplus.reconciliationbill.service.IReconRuleItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReconRuleItemController {

  @Autowired
  private IReconRuleItemService reconRuleItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconRuleItem ${table.comment}
   * @return
   */
  @GetMapping("/reconruleitems" )
  public XfR getReconRuleItems(XfPage page, ReconRuleItem reconRuleItem) {
    return XfR.ok(reconRuleItemServiceImpl.page(page, Wrappers.query(reconRuleItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconruleitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconRuleItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconRuleItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconruleitems")
  public XfR save(@RequestBody ReconRuleItem reconRuleItem) {
     return XfR.ok(reconRuleItemServiceImpl.save(reconRuleItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconRuleItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconruleitems/{id}")
  public XfR putUpdate(@RequestBody ReconRuleItem reconRuleItem,@PathVariable Long id) {
      reconRuleItem.setId(id);
      return XfR.ok(reconRuleItemServiceImpl.updateById(reconRuleItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconRuleItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconruleitems/{id}")
  public XfR patchUpdate(@RequestBody ReconRuleItem reconRuleItem,@PathVariable Long id) {
      ReconRuleItem upreconRuleItem = reconRuleItemServiceImpl.getById(id);
      if(upreconRuleItem != null){
        upreconRuleItem = ObjectCopyUtils.copyProperties(reconRuleItem,upreconRuleItem,true);
      }
      return XfR.ok(reconRuleItemServiceImpl.updateById(upreconRuleItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconruleitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconRuleItemServiceImpl.removeById(id));
  }

  @PostMapping("/reconruleitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconruleitem");
      params.put("request", condition);

     return XfR.ok(reconRuleItemServiceImpl.querys(params));
  }

}
