package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconSales;
import com.xforceplus.reconciliationbill.service.IReconSalesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReconSalesController {

  @Autowired
  private IReconSalesService reconSalesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconSales ${table.comment}
   * @return
   */
  @GetMapping("/reconsaless" )
  public XfR getReconSaless(XfPage page, ReconSales reconSales) {
    return XfR.ok(reconSalesServiceImpl.page(page, Wrappers.query(reconSales)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconsaless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconSalesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconSales ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconsaless")
  public XfR save(@RequestBody ReconSales reconSales) {
     return XfR.ok(reconSalesServiceImpl.save(reconSales));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconSales ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconsaless/{id}")
  public XfR putUpdate(@RequestBody ReconSales reconSales,@PathVariable Long id) {
      reconSales.setId(id);
      return XfR.ok(reconSalesServiceImpl.updateById(reconSales));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconSales ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconsaless/{id}")
  public XfR patchUpdate(@RequestBody ReconSales reconSales,@PathVariable Long id) {
      ReconSales upreconSales = reconSalesServiceImpl.getById(id);
      if(upreconSales != null){
        upreconSales = ObjectCopyUtils.copyProperties(reconSales,upreconSales,true);
      }
      return XfR.ok(reconSalesServiceImpl.updateById(upreconSales));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconsaless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconSalesServiceImpl.removeById(id));
  }

  @PostMapping("/reconsaless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconsales");
      params.put("request", condition);

     return XfR.ok(reconSalesServiceImpl.querys(params));
  }

}
