package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconSalesItem;
import com.xforceplus.reconciliationbill.service.IReconSalesItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReconSalesItemController {

  @Autowired
  private IReconSalesItemService reconSalesItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconSalesItem ${table.comment}
   * @return
   */
  @GetMapping("/reconsalesitems" )
  public XfR getReconSalesItems(XfPage page, ReconSalesItem reconSalesItem) {
    return XfR.ok(reconSalesItemServiceImpl.page(page, Wrappers.query(reconSalesItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconsalesitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconSalesItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconSalesItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconsalesitems")
  public XfR save(@RequestBody ReconSalesItem reconSalesItem) {
     return XfR.ok(reconSalesItemServiceImpl.save(reconSalesItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconSalesItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconsalesitems/{id}")
  public XfR putUpdate(@RequestBody ReconSalesItem reconSalesItem,@PathVariable Long id) {
      reconSalesItem.setId(id);
      return XfR.ok(reconSalesItemServiceImpl.updateById(reconSalesItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconSalesItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconsalesitems/{id}")
  public XfR patchUpdate(@RequestBody ReconSalesItem reconSalesItem,@PathVariable Long id) {
      ReconSalesItem upreconSalesItem = reconSalesItemServiceImpl.getById(id);
      if(upreconSalesItem != null){
        upreconSalesItem = ObjectCopyUtils.copyProperties(reconSalesItem,upreconSalesItem,true);
      }
      return XfR.ok(reconSalesItemServiceImpl.updateById(upreconSalesItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconsalesitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconSalesItemServiceImpl.removeById(id));
  }

  @PostMapping("/reconsalesitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconsalesitem");
      params.put("request", condition);

     return XfR.ok(reconSalesItemServiceImpl.querys(params));
  }

}
