package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconSelfConf;
import com.xforceplus.reconciliationbill.service.IReconSelfConfService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReconSelfConfController {

  @Autowired
  private IReconSelfConfService reconSelfConfServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconSelfConf ${table.comment}
   * @return
   */
  @GetMapping("/reconselfconfs" )
  public XfR getReconSelfConfs(XfPage page, ReconSelfConf reconSelfConf) {
    return XfR.ok(reconSelfConfServiceImpl.page(page, Wrappers.query(reconSelfConf)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconselfconfs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconSelfConfServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconSelfConf ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconselfconfs")
  public XfR save(@RequestBody ReconSelfConf reconSelfConf) {
     return XfR.ok(reconSelfConfServiceImpl.save(reconSelfConf));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconSelfConf ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconselfconfs/{id}")
  public XfR putUpdate(@RequestBody ReconSelfConf reconSelfConf,@PathVariable Long id) {
      reconSelfConf.setId(id);
      return XfR.ok(reconSelfConfServiceImpl.updateById(reconSelfConf));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconSelfConf ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconselfconfs/{id}")
  public XfR patchUpdate(@RequestBody ReconSelfConf reconSelfConf,@PathVariable Long id) {
      ReconSelfConf upreconSelfConf = reconSelfConfServiceImpl.getById(id);
      if(upreconSelfConf != null){
        upreconSelfConf = ObjectCopyUtils.copyProperties(reconSelfConf,upreconSelfConf,true);
      }
      return XfR.ok(reconSelfConfServiceImpl.updateById(upreconSelfConf));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconselfconfs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconSelfConfServiceImpl.removeById(id));
  }

  @PostMapping("/reconselfconfs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconselfconf");
      params.put("request", condition);

     return XfR.ok(reconSelfConfServiceImpl.querys(params));
  }

}
