package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconSelf;
import com.xforceplus.reconciliationbill.service.IReconSelfService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReconSelfController {

  @Autowired
  private IReconSelfService reconSelfServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconSelf ${table.comment}
   * @return
   */
  @GetMapping("/reconselfs" )
  public XfR getReconSelfs(XfPage page, ReconSelf reconSelf) {
    return XfR.ok(reconSelfServiceImpl.page(page, Wrappers.query(reconSelf)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconselfs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconSelfServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconSelf ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconselfs")
  public XfR save(@RequestBody ReconSelf reconSelf) {
     return XfR.ok(reconSelfServiceImpl.save(reconSelf));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconSelf ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconselfs/{id}")
  public XfR putUpdate(@RequestBody ReconSelf reconSelf,@PathVariable Long id) {
      reconSelf.setId(id);
      return XfR.ok(reconSelfServiceImpl.updateById(reconSelf));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconSelf ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconselfs/{id}")
  public XfR patchUpdate(@RequestBody ReconSelf reconSelf,@PathVariable Long id) {
      ReconSelf upreconSelf = reconSelfServiceImpl.getById(id);
      if(upreconSelf != null){
        upreconSelf = ObjectCopyUtils.copyProperties(reconSelf,upreconSelf,true);
      }
      return XfR.ok(reconSelfServiceImpl.updateById(upreconSelf));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconselfs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconSelfServiceImpl.removeById(id));
  }

  @PostMapping("/reconselfs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconself");
      params.put("request", condition);

     return XfR.ok(reconSelfServiceImpl.querys(params));
  }

}
