package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReqBill;
import com.xforceplus.reconciliationbill.service.IReqBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReqBillController {

  @Autowired
  private IReqBillService reqBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reqBill ${table.comment}
   * @return
   */
  @GetMapping("/reqbills" )
  public XfR getReqBills(XfPage page, ReqBill reqBill) {
    return XfR.ok(reqBillServiceImpl.page(page, Wrappers.query(reqBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reqbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reqBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reqBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/reqbills")
  public XfR save(@RequestBody ReqBill reqBill) {
     return XfR.ok(reqBillServiceImpl.save(reqBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reqBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/reqbills/{id}")
  public XfR putUpdate(@RequestBody ReqBill reqBill,@PathVariable Long id) {
      reqBill.setId(id);
      return XfR.ok(reqBillServiceImpl.updateById(reqBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reqBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reqbills/{id}")
  public XfR patchUpdate(@RequestBody ReqBill reqBill,@PathVariable Long id) {
      ReqBill upreqBill = reqBillServiceImpl.getById(id);
      if(upreqBill != null){
        upreqBill = ObjectCopyUtils.copyProperties(reqBill,upreqBill,true);
      }
      return XfR.ok(reqBillServiceImpl.updateById(upreqBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reqbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reqBillServiceImpl.removeById(id));
  }

  @PostMapping("/reqbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reqbill");
      params.put("request", condition);

     return XfR.ok(reqBillServiceImpl.querys(params));
  }

}
