package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReqBillItem;
import com.xforceplus.reconciliationbill.service.IReqBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-24
 */
@RestController
public class ReqBillItemController {

  @Autowired
  private IReqBillItemService reqBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reqBillItem ${table.comment}
   * @return
   */
  @GetMapping("/reqbillitems" )
  public XfR getReqBillItems(XfPage page, ReqBillItem reqBillItem) {
    return XfR.ok(reqBillItemServiceImpl.page(page, Wrappers.query(reqBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reqbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reqBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reqBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/reqbillitems")
  public XfR save(@RequestBody ReqBillItem reqBillItem) {
     return XfR.ok(reqBillItemServiceImpl.save(reqBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reqBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/reqbillitems/{id}")
  public XfR putUpdate(@RequestBody ReqBillItem reqBillItem,@PathVariable Long id) {
      reqBillItem.setId(id);
      return XfR.ok(reqBillItemServiceImpl.updateById(reqBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reqBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reqbillitems/{id}")
  public XfR patchUpdate(@RequestBody ReqBillItem reqBillItem,@PathVariable Long id) {
      ReqBillItem upreqBillItem = reqBillItemServiceImpl.getById(id);
      if(upreqBillItem != null){
        upreqBillItem = ObjectCopyUtils.copyProperties(reqBillItem,upreqBillItem,true);
      }
      return XfR.ok(reqBillItemServiceImpl.updateById(upreqBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reqbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reqBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/reqbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reqbillitem");
      params.put("request", condition);

     return XfR.ok(reqBillItemServiceImpl.querys(params));
  }

}
