package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.OneTest;
import com.xforceplus.reconciliationbill.service.IOneTestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-30
 */
@RestController
public class OneTestController {

  @Autowired
  private IOneTestService oneTestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneTest ${table.comment}
   * @return
   */
  @GetMapping("/onetests" )
  public XfR getOneTests(XfPage page, OneTest oneTest) {
    return XfR.ok(oneTestServiceImpl.page(page, Wrappers.query(oneTest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/onetests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneTestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oneTest ${table.comment}
   * @return XfR
   */
  @PostMapping("/onetests")
  public XfR save(@RequestBody OneTest oneTest) {
     return XfR.ok(oneTestServiceImpl.save(oneTest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oneTest ${table.comment}
   * @return XfR
   */
  @PutMapping("/onetests/{id}")
  public XfR putUpdate(@RequestBody OneTest oneTest,@PathVariable Long id) {
      oneTest.setId(id);
      return XfR.ok(oneTestServiceImpl.updateById(oneTest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oneTest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/onetests/{id}")
  public XfR patchUpdate(@RequestBody OneTest oneTest,@PathVariable Long id) {
      OneTest uponeTest = oneTestServiceImpl.getById(id);
      if(uponeTest != null){
        uponeTest = ObjectCopyUtils.copyProperties(oneTest,uponeTest,true);
      }
      return XfR.ok(oneTestServiceImpl.updateById(uponeTest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/onetests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneTestServiceImpl.removeById(id));
  }

  @PostMapping("/onetests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "onetest");
      params.put("request", condition);

     return XfR.ok(oneTestServiceImpl.querys(params));
  }

}
