package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconBill;
import com.xforceplus.reconciliationbill.service.IReconBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-30
 */
@RestController
public class ReconBillController {

  @Autowired
  private IReconBillService reconBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconBill ${table.comment}
   * @return
   */
  @GetMapping("/reconbills" )
  public XfR getReconBills(XfPage page, ReconBill reconBill) {
    return XfR.ok(reconBillServiceImpl.page(page, Wrappers.query(reconBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconbills")
  public XfR save(@RequestBody ReconBill reconBill) {
     return XfR.ok(reconBillServiceImpl.save(reconBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconbills/{id}")
  public XfR putUpdate(@RequestBody ReconBill reconBill,@PathVariable Long id) {
      reconBill.setId(id);
      return XfR.ok(reconBillServiceImpl.updateById(reconBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconbills/{id}")
  public XfR patchUpdate(@RequestBody ReconBill reconBill,@PathVariable Long id) {
      ReconBill upreconBill = reconBillServiceImpl.getById(id);
      if(upreconBill != null){
        upreconBill = ObjectCopyUtils.copyProperties(reconBill,upreconBill,true);
      }
      return XfR.ok(reconBillServiceImpl.updateById(upreconBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconBillServiceImpl.removeById(id));
  }

  @PostMapping("/reconbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconbill");
      params.put("request", condition);

     return XfR.ok(reconBillServiceImpl.querys(params));
  }

}
