package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconBillItem;
import com.xforceplus.reconciliationbill.service.IReconBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-30
 */
@RestController
public class ReconBillItemController {

  @Autowired
  private IReconBillItemService reconBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconBillItem ${table.comment}
   * @return
   */
  @GetMapping("/reconbillitems" )
  public XfR getReconBillItems(XfPage page, ReconBillItem reconBillItem) {
    return XfR.ok(reconBillItemServiceImpl.page(page, Wrappers.query(reconBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconbillitems")
  public XfR save(@RequestBody ReconBillItem reconBillItem) {
     return XfR.ok(reconBillItemServiceImpl.save(reconBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconbillitems/{id}")
  public XfR putUpdate(@RequestBody ReconBillItem reconBillItem,@PathVariable Long id) {
      reconBillItem.setId(id);
      return XfR.ok(reconBillItemServiceImpl.updateById(reconBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconbillitems/{id}")
  public XfR patchUpdate(@RequestBody ReconBillItem reconBillItem,@PathVariable Long id) {
      ReconBillItem upreconBillItem = reconBillItemServiceImpl.getById(id);
      if(upreconBillItem != null){
        upreconBillItem = ObjectCopyUtils.copyProperties(reconBillItem,upreconBillItem,true);
      }
      return XfR.ok(reconBillItemServiceImpl.updateById(upreconBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/reconbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconbillitem");
      params.put("request", condition);

     return XfR.ok(reconBillItemServiceImpl.querys(params));
  }

}
