package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReconSelfItem;
import com.xforceplus.reconciliationbill.service.IReconSelfItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-30
 */
@RestController
public class ReconSelfItemController {

  @Autowired
  private IReconSelfItemService reconSelfItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconSelfItem ${table.comment}
   * @return
   */
  @GetMapping("/reconselfitems" )
  public XfR getReconSelfItems(XfPage page, ReconSelfItem reconSelfItem) {
    return XfR.ok(reconSelfItemServiceImpl.page(page, Wrappers.query(reconSelfItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconselfitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconSelfItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconSelfItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconselfitems")
  public XfR save(@RequestBody ReconSelfItem reconSelfItem) {
     return XfR.ok(reconSelfItemServiceImpl.save(reconSelfItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconSelfItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconselfitems/{id}")
  public XfR putUpdate(@RequestBody ReconSelfItem reconSelfItem,@PathVariable Long id) {
      reconSelfItem.setId(id);
      return XfR.ok(reconSelfItemServiceImpl.updateById(reconSelfItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconSelfItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconselfitems/{id}")
  public XfR patchUpdate(@RequestBody ReconSelfItem reconSelfItem,@PathVariable Long id) {
      ReconSelfItem upreconSelfItem = reconSelfItemServiceImpl.getById(id);
      if(upreconSelfItem != null){
        upreconSelfItem = ObjectCopyUtils.copyProperties(reconSelfItem,upreconSelfItem,true);
      }
      return XfR.ok(reconSelfItemServiceImpl.updateById(upreconSelfItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconselfitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconSelfItemServiceImpl.removeById(id));
  }

  @PostMapping("/reconselfitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reconselfitem");
      params.put("request", condition);

     return XfR.ok(reconSelfItemServiceImpl.querys(params));
  }

}
