package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReqInfo;
import com.xforceplus.reconciliationbill.service.IReqInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-30
 */
@RestController
public class ReqInfoController {

  @Autowired
  private IReqInfoService reqInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reqInfo ${table.comment}
   * @return
   */
  @GetMapping("/reqinfos" )
  public XfR getReqInfos(XfPage page, ReqInfo reqInfo) {
    return XfR.ok(reqInfoServiceImpl.page(page, Wrappers.query(reqInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reqinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reqInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reqInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/reqinfos")
  public XfR save(@RequestBody ReqInfo reqInfo) {
     return XfR.ok(reqInfoServiceImpl.save(reqInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reqInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/reqinfos/{id}")
  public XfR putUpdate(@RequestBody ReqInfo reqInfo,@PathVariable Long id) {
      reqInfo.setId(id);
      return XfR.ok(reqInfoServiceImpl.updateById(reqInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reqInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reqinfos/{id}")
  public XfR patchUpdate(@RequestBody ReqInfo reqInfo,@PathVariable Long id) {
      ReqInfo upreqInfo = reqInfoServiceImpl.getById(id);
      if(upreqInfo != null){
        upreqInfo = ObjectCopyUtils.copyProperties(reqInfo,upreqInfo,true);
      }
      return XfR.ok(reqInfoServiceImpl.updateById(upreqInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reqinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reqInfoServiceImpl.removeById(id));
  }

  @PostMapping("/reqinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reqinfo");
      params.put("request", condition);

     return XfR.ok(reqInfoServiceImpl.querys(params));
  }

}
