package com.xforceplus.reconciliationbill.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.reconciliationbill.entity.ReqInfoItem;
import com.xforceplus.reconciliationbill.service.IReqInfoItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-30
 */
@RestController
public class ReqInfoItemController {

  @Autowired
  private IReqInfoItemService reqInfoItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reqInfoItem ${table.comment}
   * @return
   */
  @GetMapping("/reqinfoitems" )
  public XfR getReqInfoItems(XfPage page, ReqInfoItem reqInfoItem) {
    return XfR.ok(reqInfoItemServiceImpl.page(page, Wrappers.query(reqInfoItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reqinfoitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reqInfoItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reqInfoItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/reqinfoitems")
  public XfR save(@RequestBody ReqInfoItem reqInfoItem) {
     return XfR.ok(reqInfoItemServiceImpl.save(reqInfoItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reqInfoItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/reqinfoitems/{id}")
  public XfR putUpdate(@RequestBody ReqInfoItem reqInfoItem,@PathVariable Long id) {
      reqInfoItem.setId(id);
      return XfR.ok(reqInfoItemServiceImpl.updateById(reqInfoItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reqInfoItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reqinfoitems/{id}")
  public XfR patchUpdate(@RequestBody ReqInfoItem reqInfoItem,@PathVariable Long id) {
      ReqInfoItem upreqInfoItem = reqInfoItemServiceImpl.getById(id);
      if(upreqInfoItem != null){
        upreqInfoItem = ObjectCopyUtils.copyProperties(reqInfoItem,upreqInfoItem,true);
      }
      return XfR.ok(reqInfoItemServiceImpl.updateById(upreqInfoItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reqinfoitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reqInfoItemServiceImpl.removeById(id));
  }

  @PostMapping("/reqinfoitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reqinfoitem");
      params.put("request", condition);

     return XfR.ok(reqInfoItemServiceImpl.querys(params));
  }

}
