package com.xforceplus.refinedoilinventory.controller;


/**
 * feign客户端
 *
 * @author wangzheng
 * @date 2020-07-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.Inventorytaxno;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "refined-oil-inventory")
public interface InventorytaxnoFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/inventorytaxno/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param inventorytaxno 
   * @return R
   */
  @PostMapping("/inventorytaxno/add")
  public R save(@RequestBody Inventorytaxno inventorytaxno);

  /**
   * 修改
   * @param inventorytaxno 
   * @return R
   */
  @PostMapping("/inventorytaxno/update")
  public R updateById(@RequestBody Inventorytaxno inventorytaxno);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/inventorytaxno/del/{id}" )
  public R removeById(@PathVariable Long id);

}