package com.xforceplus.refinedoilinventory.controller;


/**
 * feign客户端
 *
 * @author wangzheng
 * @date 2020-07-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.RuleCondition;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "refined-oil-inventory")
public interface RuleConditionFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/ruleCondition/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param ruleCondition 
   * @return R
   */
  @PostMapping("/ruleCondition/add")
  public R save(@RequestBody RuleCondition ruleCondition);

  /**
   * 修改
   * @param ruleCondition 
   * @return R
   */
  @PostMapping("/ruleCondition/update")
  public R updateById(@RequestBody RuleCondition ruleCondition);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/ruleCondition/del/{id}" )
  public R removeById(@PathVariable Long id);

}