package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.InventoryOperationRecord;
import com.xforceplus.refinedoilinventory.service.IInventoryOperationRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-09
 */
@RestController
public class InventoryOperationRecordController {

  @Autowired
  private IInventoryOperationRecordService inventoryOperationRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryOperationRecord ${table.comment}
   * @return
   */
  @GetMapping("/inventoryoperationrecords" )
  public XfR getInventoryOperationRecords(XfPage page, InventoryOperationRecord inventoryOperationRecord) {
    return XfR.ok(inventoryOperationRecordServiceImpl.page(page, Wrappers.query(inventoryOperationRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventoryoperationrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryOperationRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventoryOperationRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventoryoperationrecords")
  public XfR save(@RequestBody InventoryOperationRecord inventoryOperationRecord) {
     return XfR.ok(inventoryOperationRecordServiceImpl.save(inventoryOperationRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventoryOperationRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventoryoperationrecords/{id}")
  public XfR putUpdate(@RequestBody InventoryOperationRecord inventoryOperationRecord,@PathVariable Long id) {
      inventoryOperationRecord.setId(id);
      return XfR.ok(inventoryOperationRecordServiceImpl.updateById(inventoryOperationRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventoryOperationRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventoryoperationrecords/{id}")
  public XfR patchUpdate(@RequestBody InventoryOperationRecord inventoryOperationRecord,@PathVariable Long id) {
      InventoryOperationRecord upinventoryOperationRecord = inventoryOperationRecordServiceImpl.getById(id);
      if(upinventoryOperationRecord != null){
        upinventoryOperationRecord = ObjectCopyUtils.copyProperties(inventoryOperationRecord,upinventoryOperationRecord,true);
      }
      return XfR.ok(inventoryOperationRecordServiceImpl.updateById(upinventoryOperationRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventoryoperationrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryOperationRecordServiceImpl.removeById(id));
  }

  @PostMapping("/inventoryoperationrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "inventoryoperationrecord");
      params.put("request", condition);

     return XfR.ok(inventoryOperationRecordServiceImpl.querys(params));
  }

}
