package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.Inventorydevice;
import com.xforceplus.refinedoilinventory.service.IInventorydeviceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-09
 */
@RestController
public class InventorydeviceController {

  @Autowired
  private IInventorydeviceService inventorydeviceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventorydevice ${table.comment}
   * @return
   */
  @GetMapping("/inventorydevices" )
  public XfR getInventorydevices(XfPage page, Inventorydevice inventorydevice) {
    return XfR.ok(inventorydeviceServiceImpl.page(page, Wrappers.query(inventorydevice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventorydevices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventorydeviceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventorydevice ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventorydevices")
  public XfR save(@RequestBody Inventorydevice inventorydevice) {
     return XfR.ok(inventorydeviceServiceImpl.save(inventorydevice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventorydevice ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventorydevices/{id}")
  public XfR putUpdate(@RequestBody Inventorydevice inventorydevice,@PathVariable Long id) {
      inventorydevice.setId(id);
      return XfR.ok(inventorydeviceServiceImpl.updateById(inventorydevice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventorydevice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventorydevices/{id}")
  public XfR patchUpdate(@RequestBody Inventorydevice inventorydevice,@PathVariable Long id) {
      Inventorydevice upinventorydevice = inventorydeviceServiceImpl.getById(id);
      if(upinventorydevice != null){
        upinventorydevice = ObjectCopyUtils.copyProperties(inventorydevice,upinventorydevice,true);
      }
      return XfR.ok(inventorydeviceServiceImpl.updateById(upinventorydevice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventorydevices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventorydeviceServiceImpl.removeById(id));
  }

  @PostMapping("/inventorydevices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "inventorydevice");
      params.put("request", condition);

     return XfR.ok(inventorydeviceServiceImpl.querys(params));
  }

}
