package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.Inventorytaxno;
import com.xforceplus.refinedoilinventory.service.IInventorytaxnoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-09
 */
@RestController
public class InventorytaxnoController {

  @Autowired
  private IInventorytaxnoService inventorytaxnoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventorytaxno ${table.comment}
   * @return
   */
  @GetMapping("/inventorytaxnos" )
  public XfR getInventorytaxnos(XfPage page, Inventorytaxno inventorytaxno) {
    return XfR.ok(inventorytaxnoServiceImpl.page(page, Wrappers.query(inventorytaxno)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventorytaxnos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventorytaxnoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventorytaxno ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventorytaxnos")
  public XfR save(@RequestBody Inventorytaxno inventorytaxno) {
     return XfR.ok(inventorytaxnoServiceImpl.save(inventorytaxno));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventorytaxno ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventorytaxnos/{id}")
  public XfR putUpdate(@RequestBody Inventorytaxno inventorytaxno,@PathVariable Long id) {
      inventorytaxno.setId(id);
      return XfR.ok(inventorytaxnoServiceImpl.updateById(inventorytaxno));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventorytaxno ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventorytaxnos/{id}")
  public XfR patchUpdate(@RequestBody Inventorytaxno inventorytaxno,@PathVariable Long id) {
      Inventorytaxno upinventorytaxno = inventorytaxnoServiceImpl.getById(id);
      if(upinventorytaxno != null){
        upinventorytaxno = ObjectCopyUtils.copyProperties(inventorytaxno,upinventorytaxno,true);
      }
      return XfR.ok(inventorytaxnoServiceImpl.updateById(upinventorytaxno));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventorytaxnos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventorytaxnoServiceImpl.removeById(id));
  }

  @PostMapping("/inventorytaxnos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "inventorytaxno");
      params.put("request", condition);

     return XfR.ok(inventorytaxnoServiceImpl.querys(params));
  }

}
