package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.RuleResource;
import com.xforceplus.refinedoilinventory.service.IRuleResourceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-09
 */
@RestController
public class RuleResourceController {

  @Autowired
  private IRuleResourceService ruleResourceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ruleResource ${table.comment}
   * @return
   */
  @GetMapping("/ruleresources" )
  public XfR getRuleResources(XfPage page, RuleResource ruleResource) {
    return XfR.ok(ruleResourceServiceImpl.page(page, Wrappers.query(ruleResource)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ruleresources/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ruleResourceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ruleResource ${table.comment}
   * @return XfR
   */
  @PostMapping("/ruleresources")
  public XfR save(@RequestBody RuleResource ruleResource) {
     return XfR.ok(ruleResourceServiceImpl.save(ruleResource));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ruleResource ${table.comment}
   * @return XfR
   */
  @PutMapping("/ruleresources/{id}")
  public XfR putUpdate(@RequestBody RuleResource ruleResource,@PathVariable Long id) {
      ruleResource.setId(id);
      return XfR.ok(ruleResourceServiceImpl.updateById(ruleResource));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ruleResource ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ruleresources/{id}")
  public XfR patchUpdate(@RequestBody RuleResource ruleResource,@PathVariable Long id) {
      RuleResource upruleResource = ruleResourceServiceImpl.getById(id);
      if(upruleResource != null){
        upruleResource = ObjectCopyUtils.copyProperties(ruleResource,upruleResource,true);
      }
      return XfR.ok(ruleResourceServiceImpl.updateById(upruleResource));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ruleresources/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ruleResourceServiceImpl.removeById(id));
  }

  @PostMapping("/ruleresources/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ruleresource");
      params.put("request", condition);

     return XfR.ok(ruleResourceServiceImpl.querys(params));
  }

}
