package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.InventoryOptLog;
import com.xforceplus.refinedoilinventory.service.IInventoryOptLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-04
 */
@RestController
public class InventoryOptLogController {

  @Autowired
  private IInventoryOptLogService inventoryOptLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryOptLog ${table.comment}
   * @return
   */
  @GetMapping("/inventoryoptlogs" )
  public XfR getInventoryOptLogs(XfPage page, InventoryOptLog inventoryOptLog) {
    return XfR.ok(inventoryOptLogServiceImpl.page(page, Wrappers.query(inventoryOptLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventoryoptlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryOptLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventoryOptLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventoryoptlogs")
  public XfR save(@RequestBody InventoryOptLog inventoryOptLog) {
     return XfR.ok(inventoryOptLogServiceImpl.save(inventoryOptLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventoryOptLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventoryoptlogs/{id}")
  public XfR putUpdate(@RequestBody InventoryOptLog inventoryOptLog,@PathVariable Long id) {
      inventoryOptLog.setId(id);
      return XfR.ok(inventoryOptLogServiceImpl.updateById(inventoryOptLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventoryOptLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventoryoptlogs/{id}")
  public XfR patchUpdate(@RequestBody InventoryOptLog inventoryOptLog,@PathVariable Long id) {
      InventoryOptLog upinventoryOptLog = inventoryOptLogServiceImpl.getById(id);
      if(upinventoryOptLog != null){
        upinventoryOptLog = ObjectCopyUtils.copyProperties(inventoryOptLog,upinventoryOptLog,true);
      }
      return XfR.ok(inventoryOptLogServiceImpl.updateById(upinventoryOptLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventoryoptlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryOptLogServiceImpl.removeById(id));
  }

  @PostMapping("/inventoryoptlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "inventoryoptlog");
      params.put("request", condition);

     return XfR.ok(inventoryOptLogServiceImpl.querys(params));
  }

}
