package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.OilInventoryWarningRule;
import com.xforceplus.refinedoilinventory.service.IOilInventoryWarningRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-04
 */
@RestController
public class OilInventoryWarningRuleController {

  @Autowired
  private IOilInventoryWarningRuleService oilInventoryWarningRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oilInventoryWarningRule ${table.comment}
   * @return
   */
  @GetMapping("/oilinventorywarningrules" )
  public XfR getOilInventoryWarningRules(XfPage page, OilInventoryWarningRule oilInventoryWarningRule) {
    return XfR.ok(oilInventoryWarningRuleServiceImpl.page(page, Wrappers.query(oilInventoryWarningRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/oilinventorywarningrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oilInventoryWarningRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param oilInventoryWarningRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/oilinventorywarningrules")
  public XfR save(@RequestBody OilInventoryWarningRule oilInventoryWarningRule) {
     return XfR.ok(oilInventoryWarningRuleServiceImpl.save(oilInventoryWarningRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param oilInventoryWarningRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/oilinventorywarningrules/{id}")
  public XfR putUpdate(@RequestBody OilInventoryWarningRule oilInventoryWarningRule,@PathVariable Long id) {
      oilInventoryWarningRule.setId(id);
      return XfR.ok(oilInventoryWarningRuleServiceImpl.updateById(oilInventoryWarningRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param oilInventoryWarningRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/oilinventorywarningrules/{id}")
  public XfR patchUpdate(@RequestBody OilInventoryWarningRule oilInventoryWarningRule,@PathVariable Long id) {
      OilInventoryWarningRule upoilInventoryWarningRule = oilInventoryWarningRuleServiceImpl.getById(id);
      if(upoilInventoryWarningRule != null){
        upoilInventoryWarningRule = ObjectCopyUtils.copyProperties(oilInventoryWarningRule,upoilInventoryWarningRule,true);
      }
      return XfR.ok(oilInventoryWarningRuleServiceImpl.updateById(upoilInventoryWarningRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oilinventorywarningrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oilInventoryWarningRuleServiceImpl.removeById(id));
  }

  @PostMapping("/oilinventorywarningrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "oilinventorywarningrule");
      params.put("request", condition);

     return XfR.ok(oilInventoryWarningRuleServiceImpl.querys(params));
  }

}
