package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.RuleAction;
import com.xforceplus.refinedoilinventory.service.IRuleActionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-04
 */
@RestController
public class RuleActionController {

  @Autowired
  private IRuleActionService ruleActionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ruleAction ${table.comment}
   * @return
   */
  @GetMapping("/ruleactions" )
  public XfR getRuleActions(XfPage page, RuleAction ruleAction) {
    return XfR.ok(ruleActionServiceImpl.page(page, Wrappers.query(ruleAction)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ruleactions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ruleActionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ruleAction ${table.comment}
   * @return XfR
   */
  @PostMapping("/ruleactions")
  public XfR save(@RequestBody RuleAction ruleAction) {
     return XfR.ok(ruleActionServiceImpl.save(ruleAction));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ruleAction ${table.comment}
   * @return XfR
   */
  @PutMapping("/ruleactions/{id}")
  public XfR putUpdate(@RequestBody RuleAction ruleAction,@PathVariable Long id) {
      ruleAction.setId(id);
      return XfR.ok(ruleActionServiceImpl.updateById(ruleAction));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ruleAction ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ruleactions/{id}")
  public XfR patchUpdate(@RequestBody RuleAction ruleAction,@PathVariable Long id) {
      RuleAction upruleAction = ruleActionServiceImpl.getById(id);
      if(upruleAction != null){
        upruleAction = ObjectCopyUtils.copyProperties(ruleAction,upruleAction,true);
      }
      return XfR.ok(ruleActionServiceImpl.updateById(upruleAction));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ruleactions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ruleActionServiceImpl.removeById(id));
  }

  @PostMapping("/ruleactions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ruleaction");
      params.put("request", condition);

     return XfR.ok(ruleActionServiceImpl.querys(params));
  }

}
