package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.RuleCondition;
import com.xforceplus.refinedoilinventory.service.IRuleConditionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-04
 */
@RestController
public class RuleConditionController {

  @Autowired
  private IRuleConditionService ruleConditionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ruleCondition ${table.comment}
   * @return
   */
  @GetMapping("/ruleconditions" )
  public XfR getRuleConditions(XfPage page, RuleCondition ruleCondition) {
    return XfR.ok(ruleConditionServiceImpl.page(page, Wrappers.query(ruleCondition)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ruleconditions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ruleConditionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ruleCondition ${table.comment}
   * @return XfR
   */
  @PostMapping("/ruleconditions")
  public XfR save(@RequestBody RuleCondition ruleCondition) {
     return XfR.ok(ruleConditionServiceImpl.save(ruleCondition));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ruleCondition ${table.comment}
   * @return XfR
   */
  @PutMapping("/ruleconditions/{id}")
  public XfR putUpdate(@RequestBody RuleCondition ruleCondition,@PathVariable Long id) {
      ruleCondition.setId(id);
      return XfR.ok(ruleConditionServiceImpl.updateById(ruleCondition));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ruleCondition ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ruleconditions/{id}")
  public XfR patchUpdate(@RequestBody RuleCondition ruleCondition,@PathVariable Long id) {
      RuleCondition upruleCondition = ruleConditionServiceImpl.getById(id);
      if(upruleCondition != null){
        upruleCondition = ObjectCopyUtils.copyProperties(ruleCondition,upruleCondition,true);
      }
      return XfR.ok(ruleConditionServiceImpl.updateById(upruleCondition));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ruleconditions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ruleConditionServiceImpl.removeById(id));
  }

  @PostMapping("/ruleconditions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "rulecondition");
      params.put("request", condition);

     return XfR.ok(ruleConditionServiceImpl.querys(params));
  }

}
