package com.xforceplus.refinedoilinventory.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.refinedoilinventory.entity.WarningRule;
import com.xforceplus.refinedoilinventory.service.IWarningRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-04
 */
@RestController
public class WarningRuleController {

  @Autowired
  private IWarningRuleService warningRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param warningRule ${table.comment}
   * @return
   */
  @GetMapping("/warningrules" )
  public XfR getWarningRules(XfPage page, WarningRule warningRule) {
    return XfR.ok(warningRuleServiceImpl.page(page, Wrappers.query(warningRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/warningrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(warningRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param warningRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/warningrules")
  public XfR save(@RequestBody WarningRule warningRule) {
     return XfR.ok(warningRuleServiceImpl.save(warningRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param warningRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/warningrules/{id}")
  public XfR putUpdate(@RequestBody WarningRule warningRule,@PathVariable Long id) {
      warningRule.setId(id);
      return XfR.ok(warningRuleServiceImpl.updateById(warningRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param warningRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/warningrules/{id}")
  public XfR patchUpdate(@RequestBody WarningRule warningRule,@PathVariable Long id) {
      WarningRule upwarningRule = warningRuleServiceImpl.getById(id);
      if(upwarningRule != null){
        upwarningRule = ObjectCopyUtils.copyProperties(warningRule,upwarningRule,true);
      }
      return XfR.ok(warningRuleServiceImpl.updateById(upwarningRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/warningrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(warningRuleServiceImpl.removeById(id));
  }

  @PostMapping("/warningrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "warningrule");
      params.put("request", condition);

     return XfR.ok(warningRuleServiceImpl.querys(params));
  }

}
