/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.pass;

import com.xforceplus.basic.pass.PaasUserInfoEntity;
import com.xforceplus.basic.pass.RetailCompanyEntity;
import com.xforceplus.basic.utils.JsonUtils;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.Company;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import feign.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(PaasClientUtil.class);

    public static IAuthorizedUser getUserInfo() {
        try {
            String params = "{\"username\":\"wuweiping@163.com\",\"password\":\"123456\"}";
            String path = "http://tenant-gateway.phoenix-t.xforceplus.com/normal/login-info";
            String encoding = "UTF-8";
            byte[] data = params.getBytes(encoding);
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json; charset=" + encoding);
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            conn.setConnectTimeout(5000);
            OutputStream outStream = conn.getOutputStream();
            outStream.write(data);
            outStream.flush();
            outStream.close();
            System.out.println(conn.getResponseCode());
            if (conn.getResponseCode() == 200) {
                InputStream inStream = conn.getInputStream();
                String result = new String(Util.toByteArray((InputStream)inStream), "UTF-8");
                System.out.println(result);
                if (StringUtils.isNotEmpty((CharSequence)result)) {
                    try {
                        result = CompressionUtils.decode((String)result);
                        System.out.println(result);
                        IAuthorizedUser userInfo = (IAuthorizedUser)JsonUtils.writeFastJsonToObject(result, AuthorizedUser.class);
                        UserInfoHolder.put((IAuthorizedUser)userInfo);
                    }
                    catch (Exception var6) {
                        logger.error("\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38");
                    }
                }
            }
            IAuthorizedUser iAuthorizedUser = UserInfoHolder.get();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return UserInfoHolder.get();
    }

    public static String fetchSellerIndentify(String orgCode) {
        IAuthorizedUser userInfo = PaasClientUtil.getUserInfo();
        Set downCompanies = userInfo.getCompanies();
        Set parentCompanies = userInfo.getParentCompanies();
        for (Company company : downCompanies) {
            if (!orgCode.equals(company.getOrgCode())) continue;
            return company.getTaxNum();
        }
        for (Company company : downCompanies) {
            if (!orgCode.equals(company.getOrgCode())) continue;
            return company.getTaxNum();
        }
        return "";
    }

    public static PaasUserInfoEntity fetchPaasUserInfo() {
        IAuthorizedUser userInfo = PaasClientUtil.getUserInfo();
        PaasUserInfoEntity paasUserInfoEntity = new PaasUserInfoEntity();
        paasUserInfoEntity.setUsername(userInfo.getUsername());
        paasUserInfoEntity.setAccountId(userInfo.getAccountId());
        paasUserInfoEntity.setEmail(userInfo.getEmail());
        paasUserInfoEntity.setId(userInfo.getId());
        paasUserInfoEntity.setMobile(userInfo.getMobile());
        paasUserInfoEntity.setTenantId(userInfo.getTenantId());
        paasUserInfoEntity.setTenantName(userInfo.getTenantName());
        ArrayList<RetailCompanyEntity> list = new ArrayList<RetailCompanyEntity>();
        RetailCompanyEntity retailCompanyEntity1 = new RetailCompanyEntity();
        retailCompanyEntity1.setTaxNo("taxNo1");
        retailCompanyEntity1.setCompanyCode("companyCode1");
        retailCompanyEntity1.setCompanyName("companyName1");
        RetailCompanyEntity retailCompanyEntity2 = new RetailCompanyEntity();
        retailCompanyEntity2.setTaxNo("taxNo2");
        retailCompanyEntity2.setCompanyCode("companyCode2");
        retailCompanyEntity2.setCompanyName("companyName2");
        list.add(retailCompanyEntity1);
        list.add(retailCompanyEntity2);
        paasUserInfoEntity.setCompanyEntities(list);
        Set companies = userInfo.getCompanies();
        ArrayList<String> companyList = new ArrayList<String>();
        companies.forEach(company -> companyList.add(company.getOrgCode()));
        paasUserInfoEntity.setOrgCodeList(companyList);
        return paasUserInfoEntity;
    }
}

