/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.pass;

import com.google.common.collect.Lists;
import com.xforceplus.basic.pass.PaasUserInfoEntity;
import com.xforceplus.basic.pass.RetailCompanyEntity;
import com.xforceplus.tenantsecurity.domain.Company;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.ICompany;
import com.xforceplus.tenantsecurity.domain.IOrg;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(PaasClientUtil.class);

    public static IAuthorizedUser getUserInfo() {
        return UserInfoHolder.get();
    }

    public static String fetchSellerIndentify(String orgCode) {
        IAuthorizedUser userInfo = PaasClientUtil.getUserInfo();
        Set downCompanies = userInfo.getCompanies();
        Set parentCompanies = userInfo.getParentCompanies();
        for (Company company : downCompanies) {
            if (!orgCode.equals(company.getOrgCode())) continue;
            return company.getTaxNum();
        }
        for (Company company : downCompanies) {
            if (!orgCode.equals(company.getOrgCode())) continue;
            return company.getTaxNum();
        }
        return "";
    }

    public static PaasUserInfoEntity fetchPaasUserInfo() {
        IAuthorizedUser userInfo = PaasClientUtil.getUserInfo();
        PaasUserInfoEntity paasUserInfoEntity = new PaasUserInfoEntity();
        paasUserInfoEntity.setUsername(userInfo.getUsername());
        paasUserInfoEntity.setAccountId(userInfo.getAccountId());
        paasUserInfoEntity.setEmail(userInfo.getEmail());
        paasUserInfoEntity.setId(userInfo.getId());
        paasUserInfoEntity.setMobile(userInfo.getMobile());
        paasUserInfoEntity.setTenantId(userInfo.getTenantId());
        paasUserInfoEntity.setTenantName(userInfo.getTenantName());
        paasUserInfoEntity.setOwnOrgCode(((IOrg)userInfo.getCurrentOrgs().get(0)).getOrgCode());
        RetailCompanyEntity retailCompanyEntity = new RetailCompanyEntity();
        ICompany iCompany = userInfo.getParentCompanies().toArray(new ICompany[0])[0];
        retailCompanyEntity.setCompanyName(iCompany.getCompanyName());
        retailCompanyEntity.setCompanyCode(iCompany.getOrgCode());
        retailCompanyEntity.setTaxNo(iCompany.getTaxNum());
        paasUserInfoEntity.setCurrentCompany(retailCompanyEntity);
        ArrayList orgCodeList = Lists.newArrayList();
        userInfo.getOrgs().forEach(org -> orgCodeList.add(org.getOrgCode()));
        orgCodeList.add(paasUserInfoEntity.getOwnOrgCode());
        paasUserInfoEntity.setOrgCodeList(orgCodeList);
        ArrayList ownCompanys = Lists.newArrayList();
        userInfo.getCompanies().forEach(ICompany2 -> {
            RetailCompanyEntity tmp = new RetailCompanyEntity();
            tmp.setCompanyName(ICompany2.getCompanyName());
            tmp.setCompanyCode(ICompany2.getOrgCode());
            tmp.setTaxNo(ICompany2.getTaxNum());
            ownCompanys.add(tmp);
        });
        paasUserInfoEntity.setCompanyEntities(ownCompanys);
        return paasUserInfoEntity;
    }

    public static PaasUserInfoEntity fetchPaasMockUserInfo() {
        PaasUserInfoEntity paasUserInfoEntity = new PaasUserInfoEntity();
        paasUserInfoEntity.setUsername("wuwu");
        paasUserInfoEntity.setAccountId(11L);
        paasUserInfoEntity.setEmail("wuwu@qq.com");
        paasUserInfoEntity.setId(89L);
        paasUserInfoEntity.setMobile("18821610009");
        paasUserInfoEntity.setTenantId(110L);
        paasUserInfoEntity.setTenantName("zzw test");
        paasUserInfoEntity.setOwnOrgCode("zzw");
        RetailCompanyEntity retailCompanyEntity = new RetailCompanyEntity();
        retailCompanyEntity.setCompanyName("zzw paas mock");
        retailCompanyEntity.setCompanyCode("zzw");
        retailCompanyEntity.setTaxNo("zzw27865323333");
        paasUserInfoEntity.setCurrentCompany(retailCompanyEntity);
        ArrayList orgCodeList = Lists.newArrayList();
        orgCodeList.add("zzw");
        paasUserInfoEntity.setOrgCodeList(orgCodeList);
        ArrayList ownCompanys = Lists.newArrayList();
        RetailCompanyEntity tmp = new RetailCompanyEntity();
        tmp.setCompanyName("zzw paas mock");
        tmp.setCompanyCode("zzw");
        tmp.setTaxNo("zzw27865323333");
        ownCompanys.add(tmp);
        paasUserInfoEntity.setCompanyEntities(ownCompanys);
        return paasUserInfoEntity;
    }
}

