/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.utils;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.slf4j.helpers.MessageFormatter;

public class CommonTools {
    private static final BeanUtilsBean beanUtilsBean = new BeanUtilsBean();
    private static final SimpleDateFormat dateFormat;
    private static final Pattern emailRegex;
    private static final Pattern mobileRegex;
    private static final String[] hexDigits;

    public static void copyProperties(Object src, Object dest) {
        try {
            beanUtilsBean.copyProperties(dest, src);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if (str.trim().length() == 0) {
            return true;
        }
        return "null".equalsIgnoreCase(str.trim());
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        try {
            return Long.valueOf(value.toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static boolean isEmpty(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static boolean useList(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static String getNumber(String str) {
        String result = "";
        Pattern p = Pattern.compile("[0-9]");
        Matcher m = p.matcher(str);
        while (m.find()) {
            result = result + m.group();
        }
        return result;
    }

    public boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static String nullToString(String str) {
        return str == null || "null".equals(str) ? "" : str;
    }

    public static String getCharater(String str) {
        String result = "";
        Pattern p = Pattern.compile("([\u4e00-\u9fa5]+)");
        Matcher m = p.matcher(str);
        while (m.find()) {
            result = result + m.group();
        }
        return result;
    }

    public static boolean checkChineseValue(String value) {
        Pattern p = Pattern.compile("^[\u4e00-\u9fa5]+$");
        Matcher m = p.matcher(value);
        boolean b = m.matches();
        return b;
    }

    public static boolean checkContainChineseValue(String value) {
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]+");
        Matcher m = p.matcher(value);
        boolean b = m.find();
        return b;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(CommonTools.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    public static String getPassword(String password) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] psd = md.digest(password.getBytes("UTF-8"));
        password = CommonTools.byteArrayToHexString(psd);
        return password;
    }

    public static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String getPlainString(String value) {
        BigDecimal bd = new BigDecimal(value);
        return bd.toPlainString();
    }

    public static String replaceStr(String res, String oldChar, String newChar) {
        if (CommonTools.isEmpty(res)) {
            return "";
        }
        return res.replace(oldChar, newChar);
    }

    public static int getLastLetterValue(String str) {
        int i;
        int result = -1;
        char[] ch = str.toCharArray();
        char[] chReverse = new char[ch.length];
        for (i = 0; i < ch.length; ++i) {
            chReverse[i] = ch[ch.length - 1 - i];
        }
        for (i = 0; i < chReverse.length; ++i) {
            String chStr = chReverse[i] + "";
            try {
                Integer.parseInt(chStr);
                continue;
            }
            catch (Exception e) {
                result = i;
                return chReverse.length - 1 - result;
            }
        }
        return result;
    }

    public static boolean exceedMaxLength(String str, int maxLength) {
        if (str == null) {
            return false;
        }
        try {
            int len = str.getBytes("GBK").length;
            return len > maxLength;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static String getCombineItemName(String itemName, String shortName) {
        return CommonTools.format("*{}*{}", shortName, itemName);
    }

    public static boolean hasShortNameInfo(String itemName) {
        Pattern pattern;
        boolean matcher;
        return !CommonTools.isEmpty(itemName) && (matcher = (pattern = Pattern.compile("^\\*.+\\*.+")).matcher(itemName).find());
    }

    public static boolean checkSameItemInfo(String itemName, String shortName) {
        return !CommonTools.isEmpty(itemName) && !CommonTools.isEmpty(shortName) && itemName.startsWith(shortName = CommonTools.format("*{}*", shortName));
    }

    public static Boolean isNumStandard(String num, int count) {
        if (CommonTools.isEmpty(num)) {
            return true;
        }
        try {
            BigDecimal bd = new BigDecimal(num);
            return bd.scale() <= count;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Boolean isNum(String num) {
        if (!CommonTools.isEmpty(num)) {
            return num.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
        }
        return false;
    }

    private static boolean isEnglish(String charaString) {
        return charaString.matches("^[a-zA-Z]*");
    }

    private static boolean isEnglishSymbol(String charaString) {
        return charaString.matches("^[%&',;=?$_\\-\\(\\)\\[\\]\\*]*");
    }

    public static String subString(String source, int len) {
        if (CommonTools.isEmpty(source) || len == 0) {
            return "";
        }
        try {
            byte[] bytes = source.getBytes("gbk");
            if (bytes.length < len) {
                return source;
            }
            if (source.length() == bytes.length) {
                return source.substring(0, len);
            }
            byte[] newByte = Arrays.copyOf(bytes, len);
            int chinese = 0;
            for (byte b : newByte) {
                if (b >= 0) continue;
                ++chinese;
            }
            if (chinese % 2 == 0) {
                return new String(newByte, "gbk");
            }
            return new String(newByte, 0, newByte.length - 1, "gbk");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean hasChinese(String companyNameKey) {
        boolean flag = false;
        String regEx = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(regEx);
        Matcher matcher = pat.matcher(companyNameKey);
        if (matcher.find()) {
            flag = true;
        }
        return flag;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String replaceTab(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\t|\r|\n|\r\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isLetterDigit(String str) {
        return str.matches("^[a-z0-9A-Z0x30-0x39]+$");
    }

    public static String converToHslf(String str) {
        String strq = str.trim().replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09");
        return strq;
    }

    public static ArrayList splitByParam(String content, int num) {
        ArrayList<String> list = new ArrayList<String>();
        if (CommonTools.isEmpty(content) || num <= 0) {
            return list;
        }
        int length = content.length();
        int size = length / num;
        for (int i = 0; i < num; ++i) {
            int beginIndex = size * i;
            int endIndex = size * (i + 1);
            String item = i == num - 1 ? content.substring(beginIndex) : content.substring(beginIndex, endIndex);
            System.out.println(item);
            item = item.replaceAll(">", "&gt");
            item = item.replaceAll("<", "&lt");
            list.add(item);
        }
        return list;
    }

    public static String subZeroAndDot(Object obj) {
        String str1 = obj + "";
        if (str1.indexOf(".") > 0) {
            str1 = str1.replaceAll("0+?$", "");
            str1 = str1.replaceAll("[.]$", "");
        }
        return str1;
    }

    public static boolean isMobileNo(String str) {
        Matcher m = mobileRegex.matcher(str);
        return m.find();
    }

    public static String format(String forrmat, Object ... args) {
        return MessageFormatter.arrayFormat((String)forrmat, (Object[])args).getMessage();
    }

    public static boolean checkCipherTextLength(String ciperText) {
        if (CommonTools.isEmpty(ciperText)) {
            return false;
        }
        return ciperText.length() == 84 || ciperText.length() == 108 || ciperText.length() == 112;
    }

    public static final String MD5(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data.getBytes("utf-8"));
            return CommonTools.encodeHex(digest.digest());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static final String encodeHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String removeLastCharacter(String str) {
        if (!CommonTools.isEmpty(str)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String defaultIfEmpty(String str, String defaultString) {
        return str == null ? defaultString : (str.trim().length() == 0 ? " " : str);
    }

    public static List toList(Map map, String id) {
        Iterator iter = map.keySet().iterator();
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (id.equalsIgnoreCase(key)) continue;
            HashMap hashMap = new HashMap();
            hashMap.put(id, map.get(id));
            hashMap.put("tableKey", key);
            hashMap.put("tableValue", map.get(key));
            list.add(hashMap);
        }
        return list;
    }

    public static List MapList2List(List list, String key) {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof Map)) continue;
            retList.add(((Map)list.get(i)).get(key) + "");
        }
        return retList;
    }

    public static void assertNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u53c2\u6570\u5bf9\u8c61\u4e3anull");
        }
    }

    public static String getValueWithDefault(String actualValue, String defaultValue) {
        if (CommonTools.isEmpty(actualValue)) {
            return defaultValue;
        }
        return actualValue;
    }

    public static BigDecimal toBigDecimal(String amount) {
        try {
            return new BigDecimal(CommonTools.isEmpty(amount) ? "0" : amount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    public static String formatDecimal(BigDecimal number, int n) {
        StringBuilder builder = n > 0 ? new StringBuilder("0.") : new StringBuilder("0");
        for (int i = 0; i < n; ++i) {
            builder.append("0");
        }
        DecimalFormat df2 = new DecimalFormat(builder.toString());
        return df2.format(number);
    }

    public static Integer toInterger(String amount) {
        try {
            return Integer.valueOf(CommonTools.isEmpty(amount) ? "0" : amount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Integer.valueOf("0");
        }
    }

    public static String getTaxItem(BigDecimal taxRate) {
        return "";
    }

    public static String splitStringWithLength(String temp, int length) {
        if (CommonTools.isEmpty(temp)) {
            return "";
        }
        if (length < 0) {
            return "";
        }
        temp = temp.length() > length ? temp.substring(0, length) : temp;
        return temp;
    }

    public static boolean validateEmail(String email) {
        if (CommonTools.isEmpty(email)) {
            return false;
        }
        Matcher matcher = emailRegex.matcher(email);
        return matcher.find();
    }

    public static boolean isPositiveInteger(String param) {
        if (param == null) {
            return false;
        }
        Matcher mer = Pattern.compile("^[1-9]\\d*$").matcher(param);
        return mer.find();
    }

    static {
        beanUtilsBean.getConvertUtils().register((Converter)new BigDecimalConverter(null), BigDecimal.class);
        beanUtilsBean.getConvertUtils().register((Converter)new DateConverter(null), java.util.Date.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlTimestampConverter(null), Timestamp.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlDateConverter(null), Date.class);
        beanUtilsBean.getConvertUtils().register((Converter)new SqlTimeConverter(null), Time.class);
        dateFormat = new SimpleDateFormat("yyyyMMdd");
        emailRegex = Pattern.compile("^([a-z0-9A-Z]+[_\\-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$");
        mobileRegex = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    }
}

