/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Function;

public class DateUtils {
    public static Function<String, String> datacollects = key -> {
        switch (key) {
            case "DT1": {
                return DateUtils.getUtcTimeFromNow();
            }
            case "DT2": {
                return DateUtils.getSimpleDateTime();
            }
            case "DN": {
                return DateUtils.getSimpleDate();
            }
            case "DMP": {
                return DateUtils.getPreMonthSimpleDate();
            }
            case "DP": {
                return DateUtils.getPreSimpleDate();
            }
            case "LDT": {
                return DateUtils.getCurrentTimeStamp();
            }
            case "DTP": {
                return DateUtils.getPreTwoSimpleDate();
            }
        }
        return "";
    };

    public static String getUtcTimeFromNow() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withLocale(Locale.getDefault()).withZone(ZoneId.of("UTC"));
        return formatter.format(now);
    }

    public static String getSimpleDateTime() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(now);
    }

    public static String getSimpleDate() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(now);
    }

    public static String getPreSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getPreTwoSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getPreMonthSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusMonths(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getCurrentTimeStamp() {
        LocalDate today = LocalDate.now();
        Long second = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        return second.toString();
    }

    public static int getMDayCurDayBeforeTwoDay() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        return preDate.getDayOfMonth();
    }

    public static int getMonthCurDayBeforeTwoDay() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        return preDate.getMonth().getValue();
    }

    public static String transDate(String origin) {
        return origin.replaceAll("\\/", "-");
    }
}

