/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    public static Function<String, String> datacollects = key -> {
        switch (key) {
            case "DT1": {
                return DateUtils.getUtcTimeFromNow();
            }
            case "DT2": {
                return DateUtils.getSimpleDateTime();
            }
            case "DN": {
                return DateUtils.getSimpleDate();
            }
            case "DMP": {
                return DateUtils.getPreMonthSimpleDate();
            }
            case "DP": {
                return DateUtils.getPreSimpleDate();
            }
            case "LDT": {
                return DateUtils.getCurrentTimeStamp();
            }
            case "DTP": {
                return DateUtils.getPreTwoSimpleDate();
            }
        }
        return "";
    };

    public static String getUtcTimeFromNow() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withLocale(Locale.getDefault()).withZone(ZoneId.of("UTC"));
        return formatter.format(now);
    }

    public static String getSimpleDateTime() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(now);
    }

    public static String getSimpleDate() {
        Instant now = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(now);
    }

    public static String getPreSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getPreTwoSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getPreMonthSimpleDate() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusMonths(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        return formatter.format(preDate);
    }

    public static String getCurrentTimeStamp() {
        LocalDate today = LocalDate.now();
        Long second = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        return second.toString();
    }

    public static int getMDayCurDayBeforeTwoDay() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        return preDate.getDayOfMonth();
    }

    public static int getMonthCurDayBeforeTwoDay() {
        LocalDate today = LocalDate.now();
        LocalDate preDate = today.minusDays(2L);
        return preDate.getMonth().getValue();
    }

    public static String transDate(String origin) {
        return origin.replaceAll("\\/", "-");
    }

    public static Date stampToDate(long stamp) {
        Instant instant = Instant.ofEpochMilli(stamp);
        return Date.from(instant);
    }

    public static Long dateToStamp(Date date) {
        Instant instant = date.toInstant();
        return instant.toEpochMilli();
    }

    public static Date strToDateLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String dateToStrLong(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(dateDate);
        return dateString;
    }

    public static Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String getDateTimeString(String strDateTime) {
        Date dataTime = null;
        if (StringUtils.isNotBlank((String)strDateTime)) {
            boolean isDateTime = Pattern.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}", strDateTime);
            boolean isDate = Pattern.matches("\\d{4}-\\d{1,2}-\\d{1,2}", strDateTime);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (isDateTime) {
                dataTime = DateUtils.strToDateLong(strDateTime);
                return sdf.format(dataTime);
            }
            if (isDate) {
                dataTime = DateUtils.strToDate(strDateTime);
                return sdf.format(dataTime);
            }
        }
        return "";
    }

    public static Date getEndOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }
}

