/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.cache;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class CacheUtils {
    private static CacheManager cacheManager = CacheManager.create();
    private static final String ALBUM_SEARCH = "retailCache";

    public static String get(String key) {
        Element element;
        Cache cache = cacheManager.getCache(ALBUM_SEARCH);
        if (cache != null && (element = cache.get((Serializable)((Object)key))) != null) {
            return element.getObjectValue().toString();
        }
        return null;
    }

    public static void put(String key, String value) {
        Cache cache = cacheManager.getCache(ALBUM_SEARCH);
        if (cache != null) {
            cache.put(new Element((Serializable)((Object)key), (Serializable)((Object)value)));
        }
    }

    public static boolean remove(Object key) {
        Cache cache = cacheManager.getCache(ALBUM_SEARCH);
        if (cache != null) {
            return cache.remove(key);
        }
        return false;
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        String value = CacheUtils.get(key).toString();
        return value == null ? defaultValue : value;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getString(key));
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Nullable
    public <T> T getJSONObject(String key, Class<T> clazz, @Nullable T defaultValue) {
        String value = this.getString(key);
        try {
            Object result = JSON.parseObject((String)value, clazz);
            return (T)(result == null ? defaultValue : result);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Nullable
    public <T> T getJSONObject(String key, Class<T> clazz) {
        return this.getJSONObject(key, clazz, null);
    }

    @NotNull
    public <T> List<T> getJSONArray(String key, Class<T> clazz) {
        String value = this.getString(key);
        try {
            List result = JSON.parseArray((String)value, clazz);
            return result == null ? Lists.newArrayList() : result;
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.getString(key);
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }
}

