/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.code;

import com.xforceplus.basic.code.CodeGeneratorUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageProcess {
    public static void grayImage(String file) throws IOException {
        File SourceFile = new File(file);
        BufferedImage bs = ImageIO.read(SourceFile);
        int width = bs.getWidth();
        int height = bs.getHeight();
        BufferedImage grayImage = new BufferedImage(width, height, 12);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = bs.getRGB(i, j);
                grayImage.setRGB(i, j, rgb);
            }
        }
        String path = SourceFile.getPath();
        String location = path.substring(0, path.lastIndexOf("/")) + "/gray/" + SourceFile.getName();
        CodeGeneratorUtils.createImage(grayImage, location);
    }

    public static void twoValueImage(String sourceFile) throws IOException {
        File file = new File(sourceFile);
        BufferedImage image = ImageIO.read(file);
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage grayImage = new BufferedImage(width, height, 10);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = image.getRGB(i, j);
                grayImage.setRGB(i, j, rgb);
            }
        }
        String path = file.getPath();
        String location = path.substring(0, path.lastIndexOf("/")) + "/value/" + file.getName();
        CodeGeneratorUtils.createImage(grayImage, location);
    }

    public static void grayAndValue(String file) throws IOException {
        File sourceFile = new File(file);
        BufferedImage bs = ImageIO.read(sourceFile);
        int width = bs.getWidth();
        int height = bs.getHeight();
        BufferedImage twoValue = new BufferedImage(width, height, 10);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = bs.getRGB(i, j);
                twoValue.setRGB(i, j, rgb);
            }
        }
        BufferedImage grayImage = new BufferedImage(width, height, 12);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = twoValue.getRGB(i, j);
                grayImage.setRGB(i, j, rgb);
            }
        }
        String path = sourceFile.getPath();
        String location = path.substring(0, path.lastIndexOf("/")) + "/grayvalue/" + sourceFile.getName();
        CodeGeneratorUtils.createImage(grayImage, location);
    }

    public static void cleanNosise(BufferedImage bufferedImage) {
    }

    public static void imageProcess(String sourceFile, int fz) throws IOException {
        int j;
        int i;
        File file = new File(sourceFile);
        BufferedImage image = ImageIO.read(file);
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] arr = new int[width][height];
        BufferedImage grayImage = new BufferedImage(width, height, 10);
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                int rgb = image.getRGB(i, j);
                grayImage.setRGB(i, j, rgb);
                arr[i][j] = ImageProcess.getImageRgb(grayImage.getRGB(i, j));
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                if (ImageProcess.getGray(arr, i, j, width, height) > fz) {
                    int black = new Color(255, 255, 255).getRGB();
                    grayImage.setRGB(i, j, black);
                    continue;
                }
                int white = new Color(0, 0, 0).getRGB();
                grayImage.setRGB(i, j, white);
            }
        }
        String path = file.getPath();
        String location = path.substring(0, path.lastIndexOf("/")) + "/process/" + file.getName();
        CodeGeneratorUtils.createImage(grayImage, location);
    }

    private static int getImageRgb(int i) {
        String argb = Integer.toHexString(i);
        int r = Integer.parseInt(argb.substring(2, 4), 16);
        int g = Integer.parseInt(argb.substring(4, 6), 16);
        int b = Integer.parseInt(argb.substring(6, 8), 16);
        int result = (r + g + b) / 3;
        return result;
    }

    public static int getGray(int[][] gray, int x, int y, int w, int h) {
        int rs = gray[x][y] + (x == 0 ? 255 : gray[x - 1][y]) + (x == 0 || y == 0 ? 255 : gray[x - 1][y - 1]) + (x == 0 || y == h - 1 ? 255 : gray[x - 1][y + 1]) + (y == 0 ? 255 : gray[x][y - 1]) + (y == h - 1 ? 255 : gray[x][y + 1]) + (x == w - 1 ? 255 : gray[x + 1][y]) + (x == w - 1 || y == 0 ? 255 : gray[x + 1][y - 1]) + (x == w - 1 || y == h - 1 ? 255 : gray[x + 1][y + 1]);
        return rs / 9;
    }

    public static BufferedImage grayImage(BufferedImage bufferedImage) throws Exception {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        BufferedImage grayBufferedImage = new BufferedImage(width, height, bufferedImage.getType());
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int color = bufferedImage.getRGB(i, j);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int gray = (int)(0.3 * (double)r + 0.59 * (double)g + 0.11 * (double)b);
                int newPixel = ImageProcess.colorToRGB(255, gray, gray, gray);
                grayBufferedImage.setRGB(i, j, newPixel);
            }
        }
        return grayBufferedImage;
    }

    private static int colorToRGB(int alpha, int red, int green, int blue) {
        int newPixel = 0;
        newPixel += alpha;
        newPixel <<= 8;
        newPixel += red;
        newPixel <<= 8;
        newPixel += green;
        newPixel <<= 8;
        return newPixel += blue;
    }

    public static BufferedImage binaryImage(BufferedImage image) throws Exception {
        int w = image.getWidth();
        int h = image.getHeight();
        float[] rgb = new float[3];
        double[][] zuobiao = new double[w][h];
        int black = new Color(0, 0, 0).getRGB();
        int white = new Color(255, 255, 255).getRGB();
        BufferedImage bi = new BufferedImage(w, h, 12);
        double SW = 240.0;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (zuobiao[x][y] < SW) {
                    bi.setRGB(x, y, black);
                    continue;
                }
                bi.setRGB(x, y, white);
            }
        }
        return bi;
    }

    public static BufferedImage denoise(BufferedImage image) {
        int x;
        int y;
        int size;
        int y2;
        int x2;
        int w = image.getWidth();
        int h = image.getHeight();
        int white = new Color(255, 255, 255).getRGB();
        if (ImageProcess.isWhite(image.getRGB(1, 0)) && ImageProcess.isWhite(image.getRGB(0, 1)) && ImageProcess.isWhite(image.getRGB(1, 1))) {
            image.setRGB(0, 0, white);
        }
        if (ImageProcess.isWhite(image.getRGB(w - 2, 0)) && ImageProcess.isWhite(image.getRGB(w - 1, 1)) && ImageProcess.isWhite(image.getRGB(w - 2, 1))) {
            image.setRGB(w - 1, 0, white);
        }
        if (ImageProcess.isWhite(image.getRGB(0, h - 2)) && ImageProcess.isWhite(image.getRGB(1, h - 1)) && ImageProcess.isWhite(image.getRGB(1, h - 2))) {
            image.setRGB(0, h - 1, white);
        }
        if (ImageProcess.isWhite(image.getRGB(w - 2, h - 1)) && ImageProcess.isWhite(image.getRGB(w - 1, h - 2)) && ImageProcess.isWhite(image.getRGB(w - 2, h - 2))) {
            image.setRGB(w - 1, h - 1, white);
        }
        for (x2 = 1; x2 < w - 1; ++x2) {
            y2 = 0;
            if (!ImageProcess.isBlack(image.getRGB(x2, y2))) continue;
            size = 0;
            if (ImageProcess.isWhite(image.getRGB(x2 - 1, y2))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2 + 1, y2))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2, y2 + 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2 - 1, y2 + 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2 + 1, y2 + 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x2, y2, white);
        }
        for (x2 = 1; x2 < w - 1; ++x2) {
            y2 = h - 1;
            if (!ImageProcess.isBlack(image.getRGB(x2, y2))) continue;
            size = 0;
            if (ImageProcess.isWhite(image.getRGB(x2 - 1, y2))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2 + 1, y2))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2, y2 - 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2 + 1, y2 - 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x2 - 1, y2 - 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x2, y2, white);
        }
        for (y = 1; y < h - 1; ++y) {
            x = 0;
            if (!ImageProcess.isBlack(image.getRGB(x, y))) continue;
            size = 0;
            if (ImageProcess.isWhite(image.getRGB(x + 1, y))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x, y + 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x, y - 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x + 1, y - 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x + 1, y + 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x, y, white);
        }
        for (y = 1; y < h - 1; ++y) {
            x = w - 1;
            if (!ImageProcess.isBlack(image.getRGB(x, y))) continue;
            size = 0;
            if (ImageProcess.isWhite(image.getRGB(x - 1, y))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x, y + 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x, y - 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x - 1, y + 1))) {
                ++size;
            }
            if (ImageProcess.isWhite(image.getRGB(x - 1, y - 1))) {
                ++size;
            }
            if (size < 5) continue;
            image.setRGB(x, y, white);
        }
        for (y = 1; y < h - 1; ++y) {
            for (x = 1; x < w - 1; ++x) {
                if (!ImageProcess.isBlack(image.getRGB(x, y))) continue;
                size = 0;
                if (ImageProcess.isWhite(image.getRGB(x - 1, y))) {
                    ++size;
                }
                if (ImageProcess.isWhite(image.getRGB(x + 1, y))) {
                    ++size;
                }
                if (ImageProcess.isWhite(image.getRGB(x, y + 1))) {
                    ++size;
                }
                if (ImageProcess.isWhite(image.getRGB(x, y - 1))) {
                    ++size;
                }
                if (ImageProcess.isWhite(image.getRGB(x - 1, y + 1))) {
                    ++size;
                }
                if (ImageProcess.isWhite(image.getRGB(x + 1, y - 1))) {
                    ++size;
                }
                if (ImageProcess.isWhite(image.getRGB(x + 1, y + 1))) {
                    ++size;
                }
                if (ImageProcess.isWhite(image.getRGB(x - 1, y - 1))) {
                    ++size;
                }
                if (size < 8) continue;
                image.setRGB(x, y, white);
            }
        }
        return image;
    }

    public static boolean isBlack(int colorInt) {
        Color color = new Color(colorInt);
        return color.getRed() + color.getGreen() + color.getBlue() <= 300;
    }

    public static boolean isWhite(int colorInt) {
        Color color = new Color(colorInt);
        return color.getRed() + color.getGreen() + color.getBlue() > 300;
    }

    public static int isBlack(int colorInt, int whiteThreshold) {
        Color color = new Color(colorInt);
        if (color.getRed() + color.getGreen() + color.getBlue() <= whiteThreshold) {
            return 1;
        }
        return 0;
    }
}

