/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.utils;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;

public class MoneyUtil {
    public static DecimalFormat fnum = new DecimalFormat("##0.00000000000000000000");

    public static String formatMoney(String value) {
        if (value == null || value == "") {
            value = "0.00";
        }
        return fnum.format(new BigDecimal(value));
    }

    public static String moneyAdd(String valueStr, String addStr) {
        BigDecimal value = new BigDecimal(valueStr);
        BigDecimal augend = new BigDecimal(addStr);
        return fnum.format(value.add(augend));
    }

    public static BigDecimal moneyAdd(BigDecimal value, BigDecimal augend) {
        return value.add(augend);
    }

    public static String moneySub(String valueStr, String minusStr) {
        BigDecimal value = new BigDecimal(valueStr);
        BigDecimal subtrahend = new BigDecimal(minusStr);
        return fnum.format(value.subtract(subtrahend));
    }

    public static BigDecimal moneySub(BigDecimal value, BigDecimal subtrahend) {
        return value.subtract(subtrahend);
    }

    public static String moneyMul(String valueStr, String mulStr) {
        BigDecimal value = new BigDecimal(valueStr);
        BigDecimal mulValue = new BigDecimal(mulStr);
        return fnum.format(value.multiply(mulValue));
    }

    public static BigDecimal moneyMul(BigDecimal value, BigDecimal mulValue) {
        return value.multiply(mulValue);
    }

    public static String moneydiv(String valueStr, String divideStr) {
        BigDecimal value = new BigDecimal(valueStr);
        BigDecimal divideValue = new BigDecimal(divideStr);
        return fnum.format(value.divide(divideValue, 2, 4));
    }

    public static BigDecimal moneydiv(BigDecimal value, BigDecimal divideValue) {
        return value.divide(divideValue, 2, 4);
    }

    public static boolean moneyComp(String valueStr, String compValueStr) {
        BigDecimal value = new BigDecimal(valueStr);
        BigDecimal compValue = new BigDecimal(compValueStr);
        int result = value.compareTo(compValue);
        return result >= 0;
    }

    public static boolean moneyComp(BigDecimal valueStr, BigDecimal compValueStr) {
        int result = valueStr.compareTo(compValueStr);
        return result >= 0;
    }

    public static String moneyMulOfNotPoint(String valueStr, String divideStr) {
        BigDecimal value = new BigDecimal(valueStr);
        BigDecimal mulValue = new BigDecimal(divideStr);
        valueStr = fnum.format(value.multiply(mulValue));
        return fnum.format(value.multiply(mulValue)).substring(0, valueStr.length() - 3);
    }

    public static String addComma(String str) {
        try {
            String[] arr;
            String banNum = "";
            if (str.contains(".") && (arr = str.split("\\.")).length == 2) {
                str = arr[0];
                banNum = "." + arr[1];
            }
            String reverseStr = new StringBuilder(str).reverse().toString();
            String strTemp = "";
            for (int i = 0; i < reverseStr.length(); ++i) {
                if (i * 3 + 3 > reverseStr.length()) {
                    strTemp = strTemp + reverseStr.substring(i * 3, reverseStr.length());
                    break;
                }
                strTemp = strTemp + reverseStr.substring(i * 3, i * 3 + 3) + ",";
            }
            if (strTemp.endsWith(",")) {
                strTemp = strTemp.substring(0, strTemp.length() - 1);
            }
            String resultStr = new StringBuilder(strTemp).reverse().toString();
            resultStr = resultStr + banNum;
            return resultStr;
        }
        catch (Exception e) {
            return str;
        }
    }

    public static void countByRateAndWithTaxPrice(HashMap<String, String> goodMap, BigDecimal count, BigDecimal taxRate, BigDecimal withTaxPrice) {
        taxRate = MoneyUtil.moneyMul(taxRate, new BigDecimal(0.01));
        BigDecimal barePrice = MoneyUtil.moneydiv(withTaxPrice, MoneyUtil.moneyAdd(new BigDecimal(1), taxRate));
        goodMap.put("\u51c0\u4ef7", barePrice.toPlainString());
        goodMap.put("\u51c0\u989d", MoneyUtil.moneyMul(barePrice, count).toPlainString());
        goodMap.put("\u7a0e\u989d", MoneyUtil.moneyMul(MoneyUtil.moneyMul(withTaxPrice, taxRate), count).setScale(2, 4).toPlainString());
        goodMap.put("\u603b\u91d1\u989d", MoneyUtil.moneyMul(withTaxPrice, count).toPlainString());
    }

    public static void countByRateAndWithTaxPrice(JSONObject goodMap, BigDecimal count, BigDecimal taxRate, BigDecimal withTaxPrice) {
        taxRate = MoneyUtil.moneyMul(taxRate, new BigDecimal(0.01));
        BigDecimal barePrice = MoneyUtil.moneydiv(withTaxPrice, MoneyUtil.moneyAdd(new BigDecimal(1), taxRate));
        goodMap.put("\u51c0\u4ef7", (Object)barePrice.toPlainString());
        goodMap.put("\u51c0\u989d", (Object)MoneyUtil.moneyMul(barePrice, count).toPlainString());
        goodMap.put("\u7a0e\u989d", (Object)MoneyUtil.moneyMul(MoneyUtil.moneyMul(withTaxPrice, taxRate), count).setScale(2, 4).toPlainString());
        goodMap.put("\u603b\u91d1\u989d", (Object)MoneyUtil.moneyMul(withTaxPrice, count).toPlainString());
    }
}

