/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.code;

import com.xforceplus.basic.utils.GenerateUUID;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGeneratorUtils {
    private static Logger logger = LoggerFactory.getLogger(CodeGeneratorUtils.class);
    private static final String KEY = "randomCode";
    private static final String KEY_TOTAL = "select_random_code_total";
    private static final String KEY_SUCC = "select_random_code_succ";
    private static final String KEY_FAIL = "select_random_code_fail";
    private static final int CACHE_SECONDS = 604800;
    private static final int ERROR_AMOUNT = 12;
    private static Integer[] arr = new Integer[]{1, 2, 3, 4, 5};
    private static Color[] colors = new Color[]{Color.GRAY, Color.LIGHT_GRAY, Color.CYAN};

    public static void createImageReaderBigcH(String path) {
        BufferedImage image = CodeGeneratorUtils.getBackGround();
        int hight = image.getHeight();
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.red);
        graphics.setFont(new Font("\u5b8b\u4f53", 1, 30));
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        List<Integer> intList = Arrays.asList(arr);
        Collections.shuffle(intList);
        ArrayList<String> codeList = new ArrayList<String>();
        int x = 0;
        int y = 0;
        int num = random.nextInt(arr.length) + 1;
        for (int i = 0; i < arr.length; ++i) {
            String ch = CodeGeneratorUtils.getRandomChineseChar();
            int place = intList.get(i);
            if (place == 1) {
                x = new Random().nextInt(30) + 40;
                y = new Random().nextInt(30) + 40;
            }
            if (place == 2) {
                x = new Random().nextInt(40) + 120;
                y = new Random().nextInt(30) + 50;
            }
            if (place == 3) {
                x = new Random().nextInt(70) + 200;
                y = new Random().nextInt(50) + 100;
            }
            if (place == 4) {
                x = new Random().nextInt(70) + 80;
                y = new Random().nextInt(30) + 90;
            }
            if (place == 5) {
                x = new Random().nextInt(70) + 180;
                y = new Random().nextInt(30) + 50;
            }
            logger.info("x:" + x + ",y:" + y + "\uff0chight:" + hight);
            graphics.setColor(colors[random.nextInt(colors.length)]);
            graphics.drawString(ch, x, y);
            if (place == num) continue;
            sb.append(ch);
            codeList.add(x + "_" + y);
        }
        logger.info("\u6c49\u5b57\uff1a" + sb);
        logger.info("\u9a8c\u8bc1\u7801:" + codeList);
        BufferedImage bi = new BufferedImage(image.getWidth(), 25, 1);
        Graphics gra = bi.getGraphics();
        gra.setColor(Color.WHITE);
        gra.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        gra.setColor(Color.BLUE);
        gra.drawRect(1, 1, bi.getWidth() - 2, bi.getHeight() - 2);
        Font font = new Font("Microsoft YaHei", 1, 16);
        gra.setFont(font);
        gra.setColor(Color.BLACK);
        gra.drawString("\u6309\u987a\u5e8f\u70b9\u51fb\uff1a" + sb.toString(), (bi.getWidth() - 10 * font.getSize()) / 2, bi.getHeight() / 2 + font.getSize() / 2);
        BufferedImage combined = new BufferedImage(image.getWidth(), image.getHeight() + bi.getHeight(), 1);
        Graphics g = combined.getGraphics();
        g.drawImage(bi, 0, 0, null);
        g.drawImage(image, 0, bi.getHeight(), null);
        String location = path + GenerateUUID.generateUUid() + ".jpg";
        CodeGeneratorUtils.createImage(image, location);
    }

    public static BufferedImage getBackGround() {
        int width = 300;
        int height = 200;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        Random random = new Random();
        g.fillRect(0, 0, width, height);
        g.setColor(CodeGeneratorUtils.getRandColor(180, 200));
        g.dispose();
        return image;
    }

    private static Color getRandColor(Random random, int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static String[] generateCheckCode() {
        String[] res = new String[2];
        Random random = new Random();
        int intFirst = random.nextInt(100);
        int intSec = random.nextInt(100);
        String checkCode = "";
        int result = 0;
        switch (random.nextInt(6)) {
            case 0: {
                if (intFirst < intSec) {
                    int intTemp = intFirst;
                    intFirst = intSec;
                    intSec = intTemp;
                }
                checkCode = intFirst + " - " + intSec + " = ?";
                result = intFirst - intSec;
                break;
            }
            case 1: {
                if (intFirst < intSec) {
                    int intTemp = intFirst;
                    intFirst = intSec;
                    intSec = intTemp;
                }
                checkCode = intFirst + " - ? = " + (intFirst - intSec);
                result = intSec;
                break;
            }
            case 2: {
                if (intFirst < intSec) {
                    int intTemp = intFirst;
                    intFirst = intSec;
                    intSec = intTemp;
                }
                checkCode = "? - " + intSec + " = " + (intFirst - intSec);
                result = intFirst;
                break;
            }
            case 3: {
                checkCode = intFirst + " + " + intSec + " = ?";
                result = intFirst + intSec;
                break;
            }
            case 4: {
                checkCode = intFirst + " + ? =" + (intFirst + intSec);
                result = intSec;
                break;
            }
            case 5: {
                checkCode = "? + " + intSec + " =" + (intFirst + intSec);
                result = intFirst;
            }
        }
        res[0] = checkCode;
        res[1] = String.valueOf(result);
        logger.info("result=" + result);
        return res;
    }

    public static void calcCode(String path) throws IOException {
        int width = 140;
        int height = 37;
        try {
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics g = image.getGraphics();
            Random random = new Random();
            g.setColor(CodeGeneratorUtils.getRandColor(random, 200, 250));
            g.fillRect(0, 0, width, height);
            String[] fontTypes = new String[]{"\u5b8b\u4f53", "\u65b0\u5b8b\u4f53", "\u9ed1\u4f53", "\u6977\u4f53", "\u96b6\u4e66"};
            int fontTypesLength = fontTypes.length;
            g.setColor(CodeGeneratorUtils.getRandColor(random, 160, 200));
            g.setFont(new Font("Times New Roman", 0, 14 + random.nextInt(6)));
            for (int i = 0; i < 255; ++i) {
                int x = random.nextInt(width);
                int y = random.nextInt(height);
                int xl = random.nextInt(12);
                int yl = random.nextInt(12);
                g.drawLine(x, y, x + xl, y + yl);
            }
            String[] result = CodeGeneratorUtils.generateCheckCode();
            String[] baseChar = result[0].split(" ");
            for (int i = 0; i < baseChar.length; ++i) {
                g.setColor(CodeGeneratorUtils.getRandColor(random, 30, 150));
                g.setFont(new Font(fontTypes[random.nextInt(fontTypesLength)], 1, 22 + random.nextInt(6)));
                g.drawString(baseChar[i], 24 * i + 10, 24);
            }
            g.dispose();
            String location = path + GenerateUUID.generateUUid() + ".jpg";
            CodeGeneratorUtils.createImage(image, location);
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createImage(BufferedImage image, String fileLocation) {
        FilterOutputStream bos = null;
        if (image != null) {
            try {
                FileOutputStream fos = new FileOutputStream(fileLocation);
                bos = new BufferedOutputStream(fos);
                ImageIO.write((RenderedImage)image, "jpg", bos);
                bos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void getRandomCode(String path) throws IOException {
        int width = 140;
        int height = 37;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        Random random = new Random();
        Font mFont = new Font("\u9ed1\u4f53", 1, 22);
        g.setColor(CodeGeneratorUtils.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(mFont);
        g.setColor(CodeGeneratorUtils.getRandColor(180, 200));
        for (int i = 0; i < 100; ++i) {
            int x = random.nextInt(width - 1);
            int y = random.nextInt(height - 1);
            int x1 = random.nextInt(6) + 1;
            int y1 = random.nextInt(12) + 1;
            BasicStroke bs = new BasicStroke(2.0f, 0, 2);
            Line2D.Double line = new Line2D.Double(x, y, x + x1, y + y1);
            g2d.setStroke(bs);
            g2d.draw(line);
        }
        String sRand = "";
        String ctmp = "";
        int itmp = 0;
        for (int i = 0; i < 4; ++i) {
            switch (random.nextInt(2)) {
                case 0: {
                    itmp = random.nextInt(26) + 65;
                    ctmp = String.valueOf((char)itmp);
                    break;
                }
                default: {
                    ctmp = String.valueOf(random.nextInt(8) + 2);
                }
            }
            sRand = sRand + ctmp;
            Color color = new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110));
            g.setColor(color);
            Graphics2D g2d_word = (Graphics2D)g;
            AffineTransform trans = new AffineTransform();
            trans.rotate((double)random.nextInt(45) * 3.14 / 180.0, 15 * i + 8, 7.0);
            g2d_word.setTransform(trans);
            g.drawString(ctmp, 20 * i + 18, 18);
        }
        String location = path + GenerateUUID.generateUUid() + ".jpg";
        CodeGeneratorUtils.createImage(image, location);
        g.dispose();
    }

    public static Color getRandColor(int s, int e) {
        Random random = new Random();
        if (s > 255) {
            s = 255;
        }
        if (e > 255) {
            e = 255;
        }
        int r = s + random.nextInt(e - s);
        int g = s + random.nextInt(e - s);
        int b = s + random.nextInt(e - s);
        return new Color(r, g, b);
    }

    public static String getRandomChineseChar() {
        String str = null;
        Random random = new Random();
        int hs = 176 + Math.abs(random.nextInt(39));
        int ls = 161 + Math.abs(random.nextInt(93));
        byte[] b = new byte[]{new Integer(hs).byteValue(), new Integer(ls).byteValue()};
        try {
            str = new String(b, "GBk");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return str;
    }
}

