/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.basic.model.CompanySearchEntity;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CompanySearchUtils {
    private static String path;

    public static String getPath() {
        return path;
    }

    @Value(value="${companySearch.url}")
    public void setPath(String path) {
        CompanySearchUtils.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompanyInfo(Integer page, Integer size, String keyword) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String result = "";
        try {
            httpClient = HttpClients.createDefault();
            String url = path + "?page=" + page + "&size=" + size + "&keyword=" + keyword;
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "Bearer da3efcbf-0845-4fe3-8aba-ee040be542c0");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static List<CompanySearchEntity> getCompanyContent(Integer page, Integer size, String keyword) {
        String json = CompanySearchUtils.getCompanyInfo(page, size, keyword);
        JSONObject resObject = JSONObject.parseObject((String)json);
        JSONObject jsonObject = (JSONObject)resObject.get((Object)"data");
        JSONArray jsonArray = jsonObject.getJSONArray("content");
        ArrayList<CompanySearchEntity> arrayList = new ArrayList<CompanySearchEntity>();
        for (JSONObject content : jsonArray) {
            CompanySearchEntity companySearchEntity = (CompanySearchEntity)JsonUtils.fromJson((String)JSONObject.toJSONString((Object)content), CompanySearchEntity.class);
            arrayList.add(companySearchEntity);
        }
        return arrayList;
    }
}

