/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.oss;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import java.io.File;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OSSUtils {
    private static String endpoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucket;
    static final Logger logger;

    public static String uploadFile(String objName, Date expirtDate, File file) {
        URL url = null;
        try {
            OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
            ossClient.putObject(bucket, objName, file);
            url = ossClient.generatePresignedUrl(bucket, objName, expirtDate, HttpMethod.GET);
            ossClient.shutdown();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return url == null ? null : url.toString();
    }

    public static String getEndpoint() {
        return endpoint;
    }

    @Value(value="${OSS.endpoint}")
    public void setEndpoint(String endpoint) {
        OSSUtils.endpoint = endpoint;
    }

    public static String getAccessKeyId() {
        return accessKeyId;
    }

    @Value(value="${OSS.accessKeyId}")
    public void setAccessKeyId(String accessKeyId) {
        OSSUtils.accessKeyId = accessKeyId;
    }

    public static String getAccessKeySecret() {
        return accessKeySecret;
    }

    @Value(value="${OSS.accessKeySecret}")
    public void setAccessKeySecret(String accessKeySecret) {
        OSSUtils.accessKeySecret = accessKeySecret;
    }

    public static String getBucket() {
        return bucket;
    }

    @Value(value="${OSS.bucket}")
    public void setBucket(String bucket) {
        OSSUtils.bucket = bucket;
    }

    static {
        logger = LoggerFactory.getLogger(OSSUtils.class);
    }
}

