/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.pass;

import com.google.common.collect.Lists;
import com.xforceplus.basic.pass.PaasUserInfoEntity;
import com.xforceplus.basic.pass.RetailCompanyEntity;
import com.xforceplus.basic.utils.JsonUtils;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.Company;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.ICompany;
import com.xforceplus.tenantsecurity.domain.IOrg;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import feign.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(PaasClientUtil.class);

    public static IAuthorizedUser getUserInfo() {
        return UserInfoHolder.get();
    }

    public static IAuthorizedUser getUserInfoTest() {
        try {
            String params = "{\"username\":\"gaoguilan1@xforceplus.com\",\"password\":\"123456\"}";
            String path = "http://tenant-gateway.phoenix-t.xforceplus.com/normal/login-info";
            String encoding = "UTF-8";
            byte[] data = params.getBytes(encoding);
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json; charset=" + encoding);
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            conn.setConnectTimeout(5000);
            OutputStream outStream = conn.getOutputStream();
            outStream.write(data);
            outStream.flush();
            outStream.close();
            System.out.println(conn.getResponseCode());
            if (conn.getResponseCode() == 200) {
                InputStream inStream = conn.getInputStream();
                String result = new String(Util.toByteArray((InputStream)inStream), "UTF-8");
                System.out.println(result);
                if (StringUtils.isNotEmpty((String)result)) {
                    try {
                        result = CompressionUtils.decode((String)result);
                        System.out.println(result);
                        IAuthorizedUser userInfo = (IAuthorizedUser)JsonUtils.writeFastJsonToObject(result, AuthorizedUser.class);
                        return userInfo;
                    }
                    catch (Exception var6) {
                        logger.error("\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38");
                    }
                }
            }
            IAuthorizedUser iAuthorizedUser = UserInfoHolder.get();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String fetchSellerIndentify(String orgCode) {
        IAuthorizedUser userInfo = PaasClientUtil.getUserInfo();
        Set downCompanies = userInfo.getCompanies();
        Set parentCompanies = userInfo.getParentCompanies();
        for (Company company : downCompanies) {
            if (!orgCode.equals(company.getOrgCode())) continue;
            return company.getTaxNum();
        }
        for (Company company : downCompanies) {
            if (!orgCode.equals(company.getOrgCode())) continue;
            return company.getTaxNum();
        }
        return "";
    }

    public static PaasUserInfoEntity fetchPaasUserInfo() {
        IAuthorizedUser userInfo = PaasClientUtil.getUserInfo();
        PaasUserInfoEntity paasUserInfoEntity = new PaasUserInfoEntity();
        paasUserInfoEntity.setUsername(userInfo.getUsername());
        paasUserInfoEntity.setAccountId(userInfo.getAccountId());
        paasUserInfoEntity.setEmail(userInfo.getEmail());
        paasUserInfoEntity.setId(userInfo.getId());
        paasUserInfoEntity.setMobile(userInfo.getMobile());
        paasUserInfoEntity.setTenantId(userInfo.getTenantId());
        paasUserInfoEntity.setTenantName(userInfo.getTenantName());
        if (!CollectionUtils.isEmpty((Collection)userInfo.getCurrentOrgs())) {
            paasUserInfoEntity.setOwnOrgCode(String.valueOf(((IOrg)userInfo.getCurrentOrgs().get(0)).getOrgId()));
        }
        if (!CollectionUtils.isEmpty((Collection)userInfo.getParentCompanies())) {
            RetailCompanyEntity retailCompanyEntity = new RetailCompanyEntity();
            ICompany iCompany = userInfo.getParentCompanies().toArray(new ICompany[0])[0];
            retailCompanyEntity.setCompanyName(iCompany.getCompanyName());
            retailCompanyEntity.setOrgCode(String.valueOf(iCompany.getOrgId()));
            retailCompanyEntity.setCompanyId(String.valueOf(iCompany.getCompanyId()));
            retailCompanyEntity.setTaxNum(iCompany.getTaxNum());
            paasUserInfoEntity.setCurrentCompany(retailCompanyEntity);
        } else {
            paasUserInfoEntity.setCurrentCompany(new RetailCompanyEntity());
        }
        ArrayList orgCodeList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)userInfo.getOrgs())) {
            userInfo.getOrgs().forEach(org -> orgCodeList.add(String.valueOf(org.getOrgId())));
            orgCodeList.add(paasUserInfoEntity.getOwnOrgCode());
            paasUserInfoEntity.setOrgCodeList(orgCodeList);
        } else {
            paasUserInfoEntity.setOrgCodeList(orgCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)userInfo.getCompanies())) {
            ArrayList ownCompanys = Lists.newArrayList();
            userInfo.getCompanies().forEach(ICompany2 -> {
                RetailCompanyEntity tmp = new RetailCompanyEntity();
                tmp.setCompanyName(ICompany2.getCompanyName());
                tmp.setOrgCode(String.valueOf(ICompany2.getOrgId()));
                tmp.setCompanyId(String.valueOf(ICompany2.getCompanyId()));
                tmp.setTaxNum(ICompany2.getTaxNum());
                ownCompanys.add(tmp);
            });
            paasUserInfoEntity.setCompanies(ownCompanys);
        } else {
            paasUserInfoEntity.setCompanies(Lists.newArrayList());
        }
        return paasUserInfoEntity;
    }

    public static PaasUserInfoEntity fetchPaasMockUserInfo() {
        PaasUserInfoEntity paasUserInfoEntity = new PaasUserInfoEntity();
        paasUserInfoEntity.setUsername("wuwu");
        paasUserInfoEntity.setAccountId(11L);
        paasUserInfoEntity.setEmail("wuwu@qq.com");
        paasUserInfoEntity.setId(89L);
        paasUserInfoEntity.setMobile("18821610009");
        paasUserInfoEntity.setTenantId(110L);
        paasUserInfoEntity.setTenantName("zzw test");
        paasUserInfoEntity.setOwnOrgCode("zzw");
        RetailCompanyEntity retailCompanyEntity = new RetailCompanyEntity();
        retailCompanyEntity.setCompanyName("zzw paas mock");
        retailCompanyEntity.setOrgCode("zzw");
        retailCompanyEntity.setTaxNum("zzw27865323333");
        paasUserInfoEntity.setCurrentCompany(retailCompanyEntity);
        ArrayList orgCodeList = Lists.newArrayList();
        orgCodeList.add("zzw");
        paasUserInfoEntity.setOrgCodeList(orgCodeList);
        ArrayList ownCompanys = Lists.newArrayList();
        RetailCompanyEntity tmp = new RetailCompanyEntity();
        tmp.setCompanyName("zzw paas mock");
        tmp.setOrgCode("zzw");
        tmp.setTaxNum("zzw27865323333");
        ownCompanys.add(tmp);
        paasUserInfoEntity.setCompanies(ownCompanys);
        return paasUserInfoEntity;
    }
}

