/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component
public class BigDecimalUtil {
    public String formatMax10(@NotNull BigDecimal number) {
        return this.format(number, 0, 10);
    }

    public String formatFix2(@NotNull BigDecimal number) {
        return this.format(number, 2, 2);
    }

    public String formatMin2Max10(@NotNull BigDecimal number) {
        return this.format(number, 2, 10);
    }

    public String formatFix0(@NotNull BigDecimal number) {
        return this.format(number, 0, 0);
    }

    public String format(@NotNull BigDecimal number, int minFraction, int maxFraction) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumFractionDigits(minFraction);
        decimalFormat.setMaximumFractionDigits(maxFraction);
        try {
            return decimalFormat.format(number);
        }
        catch (Exception e) {
            return number.toPlainString();
        }
    }

    public BigDecimal fromString(String number, BigDecimal defaultValue, int scale) {
        try {
            return new BigDecimal(number).setScale(scale, 4);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigDecimal fromString(String number, BigDecimal defaultValue) {
        return this.fromString(number, defaultValue, 2);
    }

    public BigDecimal fromString(String number) {
        return this.fromString(number, BigDecimal.ZERO);
    }

    public static BigDecimal add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2);
    }

    public static BigDecimal sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2);
    }

    public static BigDecimal mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2);
    }

    public static BigDecimal div(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, 2, 4);
    }
}

