/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ExcelUtil {
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";
    private Map<String, Integer> columnsMap = new HashMap<String, Integer>();
    private JSONObject configJson = null;
    private Resource resourceCfg = null;

    public ExcelUtil() {
    }

    public ExcelUtil(String cfg) {
        this.configJson = JSON.parseObject((String)cfg);
    }

    public void loadCfg(String path) {
        this.resourceCfg = new ClassPathResource(path);
        this.configJson = this.analyzeJson();
    }

    public Workbook getWorkbok(String fileName, InputStream inputStream) throws IOException {
        HSSFWorkbook wb = null;
        if (fileName.endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (fileName.endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    public Map getExcel(String fileName, InputStream inputStream) throws IOException {
        Workbook wb = this.getWorkbok(fileName, inputStream);
        if (null == this.configJson) {
            this.configJson = this.analyzeJson();
        }
        int sheetSize = wb.getNumberOfSheets();
        HashMap<String, List> jsonRes = new HashMap<String, List>();
        for (int i = 0; i < sheetSize; ++i) {
            Sheet sheet = wb.getSheetAt(i);
            this.initColumnsMap(sheet);
            List currentListPage = this.handRow(sheet, this.columnsMap);
            jsonRes.put(sheet.getSheetName(), currentListPage);
        }
        return jsonRes;
    }

    private List handRow(Sheet sheet, Map<String, Integer> columnsMap) {
        Row dataRow;
        ArrayList dataList = new ArrayList();
        for (int idx = 1; idx <= sheet.getLastRowNum() && (dataRow = sheet.getRow(idx)) != null; ++idx) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            Set<String> columnNameSet = columnsMap.keySet();
            for (String key : columnNameSet) {
                int cellIdx = columnsMap.get(key);
                String propertyName = "";
                if (this.configJson.get((Object)key) == null || this.configJson.get((Object)key).equals("")) continue;
                JSONObject colDesc = (JSONObject)this.configJson.get((Object)key);
                propertyName = colDesc.get((Object)"propertyName").toString();
                try {
                    String dataType;
                    if (dataRow.getCell(cellIdx) == null) continue;
                    switch (dataType = colDesc.get((Object)"dataType").toString()) {
                        case "string": {
                            Object propertyObj = this.getValueObj(cellIdx, dataRow);
                            if (propertyObj instanceof Number) {
                                Number number = (Number)propertyObj;
                                BigDecimal bd = new BigDecimal(number.doubleValue());
                                res.put(propertyName, bd.toPlainString());
                                break;
                            }
                            res.put(propertyName, propertyObj.toString());
                            break;
                        }
                        case "date": {
                            Date propertyDateType = dataRow.getCell(cellIdx).getDateCellValue();
                            System.out.println(propertyDateType);
                            res.put(propertyName, propertyDateType);
                            break;
                        }
                        case "number.long": {
                            Double numberLong = dataRow.getCell(cellIdx).getNumericCellValue();
                            long propertyLongType = ((Number)numberLong).longValue();
                            res.put(propertyName, propertyLongType);
                            break;
                        }
                        case "number.double": {
                            Double numberDouble = dataRow.getCell(cellIdx).getNumericCellValue();
                            double properyDoubleType = numberDouble;
                            res.put(propertyName, properyDoubleType);
                            break;
                        }
                        case "date->string": {
                            Date dateValue = dataRow.getCell(cellIdx).getDateCellValue();
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            String str = sdf.format(dateValue);
                            res.put(propertyName, str);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dataList.add(res);
        }
        return dataList;
    }

    private Object getValueObj(int idx, Row dataRow) {
        int type = dataRow.getCell(idx).getCellType();
        switch (type) {
            case 0: {
                Double number = dataRow.getCell(idx).getNumericCellValue();
                return number;
            }
            case 3: {
                return "";
            }
            case 4: {
                Boolean bool = dataRow.getCell(idx).getBooleanCellValue();
                return bool.toString();
            }
            case 1: {
                String str = dataRow.getCell(idx).getStringCellValue();
                return str;
            }
        }
        return "";
    }

    private void initColumnsMap(Sheet sheet) {
        Row row = sheet.getRow(0);
        int columnLength = row.getLastCellNum();
        for (int j = 0; j < columnLength; ++j) {
            if (row.getCell(j).toString().equals("")) continue;
            this.columnsMap.put(row.getCell(j).toString(), j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject analyzeJson() {
        JSONObject jsonObj = new JSONObject();
        try {
            File file = this.resourceCfg.getFile();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.resourceCfg.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            jsonObj = JSONObject.parseObject((String)stringBuilder.toString());
            return jsonObj;
        }
        finally {
            return jsonObj;
        }
    }

    public void createExcel(String sheetName, JSONArray array, HttpServletResponse response) throws Exception {
        HSSFWorkbook wb = this.createWorkbook(sheetName, array);
        this.buildExcelDocument(sheetName + ".xls", wb, response);
    }

    public void createExcelXlsx(String sheetName, JSONArray array, HttpServletResponse response) throws Exception {
        XSSFWorkbook wb = this.createWorkBookXlsx(sheetName, array);
        this.buildExcelDocumentXlsx(sheetName + ".xlxs", wb, response);
    }

    private HSSFWorkbook createWorkbook(String sheetName, JSONArray array) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row0 = sheet.createRow(0);
        Set set = this.configJson.keySet();
        boolean columnIdx = false;
        for (String key : set) {
            JSONObject columnJson = (JSONObject)this.configJson.get((Object)key);
            HSSFCell cell = row0.createCell(((Integer)columnJson.get((Object)"columnIdx")).intValue());
            cell.setCellValue(columnJson.get((Object)"columnName").toString());
        }
        Object json = null;
        for (int j = 0; j < array.size(); ++j) {
            HSSFRow row = sheet.createRow(j + 1);
            JSONObject rowData = (JSONObject)array.get(j);
            Set propertiesNameSet = rowData.keySet();
            for (String propertyName : propertiesNameSet) {
                String dataType;
                if (null == rowData.get((Object)propertyName)) continue;
                String strVal = "";
                long longVal = 0L;
                double doubleVal = 0.0;
                Date dateVal = null;
                if (!this.configJson.containsKey((Object)propertyName)) continue;
                JSONObject columnInfoJson = (JSONObject)this.configJson.get((Object)propertyName);
                Integer colIdx = (Integer)columnInfoJson.get((Object)"columnIdx");
                HSSFCell cell = row.createCell(colIdx.intValue());
                switch (dataType = (String)columnInfoJson.get((Object)"dataType")) {
                    case "string": {
                        strVal = (String)rowData.get((Object)propertyName);
                        cell.setCellValue(strVal);
                        break;
                    }
                    case "date": {
                        dateVal = (Date)rowData.get((Object)propertyName);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(dateVal);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/dd");
                        String dateStr = sdf.format(calendar.getTime());
                        cell.setCellValue(dateStr);
                        break;
                    }
                    case "number.long": {
                        longVal = (Long)rowData.get((Object)propertyName);
                        cell.setCellValue((double)longVal);
                        break;
                    }
                    case "number.double": {
                        doubleVal = ((Long)rowData.get((Object)propertyName)).longValue();
                        cell.setCellValue(doubleVal);
                    }
                }
            }
        }
        return wb;
    }

    private XSSFWorkbook createWorkbookXlsx(String sheetName, JSONArray array) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        XSSFRow row0 = sheet.createRow(0);
        Set set = this.configJson.keySet();
        boolean columnIdx = false;
        for (String key : set) {
            JSONObject columnJson = (JSONObject)this.configJson.get((Object)key);
            XSSFCell cell = row0.createCell(((Integer)columnJson.get((Object)"columnIdx")).intValue());
            cell.setCellValue(columnJson.get((Object)"columnName").toString());
        }
        Object json = null;
        for (int j = 0; j < array.size(); ++j) {
            XSSFRow row = sheet.createRow(j + 1);
            JSONObject rowData = (JSONObject)array.get(j);
            Set propertiesNameSet = rowData.keySet();
            for (String propertyName : propertiesNameSet) {
                String dataType;
                if (null == rowData.get((Object)propertyName)) continue;
                String strVal = "";
                long longVal = 0L;
                double doubleVal = 0.0;
                Date dateVal = null;
                if (!this.configJson.containsKey((Object)propertyName)) continue;
                JSONObject columnInfoJson = (JSONObject)this.configJson.get((Object)propertyName);
                Integer colIdx = (Integer)columnInfoJson.get((Object)"columnIdx");
                XSSFCell cell = row.createCell(colIdx.intValue());
                switch (dataType = (String)columnInfoJson.get((Object)"dataType")) {
                    case "string": {
                        strVal = (String)rowData.get((Object)propertyName);
                        cell.setCellValue(strVal);
                        break;
                    }
                    case "date": {
                        dateVal = (Date)rowData.get((Object)propertyName);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(dateVal);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/dd");
                        String dateStr = sdf.format(calendar.getTime());
                        cell.setCellValue(dateStr);
                        break;
                    }
                    case "number.long": {
                        longVal = (Long)rowData.get((Object)propertyName);
                        cell.setCellValue((double)longVal);
                        break;
                    }
                    case "number.double": {
                        doubleVal = ((Long)rowData.get((Object)propertyName)).longValue();
                        cell.setCellValue(doubleVal);
                    }
                }
            }
        }
        return wb;
    }

    private void bulidExcelFile(String file, HSSFWorkbook wb) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        wb.write((OutputStream)fos);
        fos.flush();
        fos.close();
    }

    protected void buildExcelDocument(String filename, HSSFWorkbook workbook, HttpServletResponse response) throws Exception {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        workbook.write((OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
    }

    protected void buildExcelDocumentXlsx(String filename, XSSFWorkbook workbook, HttpServletResponse response) throws Exception {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "utf-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        workbook.write((OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
    }

    public InputStream getExcelInputStream(HSSFWorkbook workbook) throws Exception {
        if (workbook != null) {
            byte[] content = workbook.getBytes();
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            return stream;
        }
        return null;
    }

    public InputStream getExcelInputStream(XSSFWorkbook workbook) throws Exception {
        if (workbook != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            workbook.write((OutputStream)os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return is;
        }
        return null;
    }

    public HSSFWorkbook createWorkBook(String sheetName, JSONArray array) throws Exception {
        HSSFWorkbook wb = this.createWorkbook(sheetName, array);
        return wb;
    }

    public XSSFWorkbook createWorkBookXlsx(String sheetName, JSONArray array) throws Exception {
        XSSFWorkbook wb = this.createWorkbookXlsx(sheetName, array);
        return wb;
    }
}

