/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.basic.utils;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import com.xforceplus.basic.code.CodeGeneratorUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingdingTalkUtils {
    private static Logger logger = LoggerFactory.getLogger(CodeGeneratorUtils.class);
    private static final String DEFAULT_WEB_HOOK = "https://oapi.dingtalk.com/robot/send?access_token=e45aaea8970602c6bcec6652931227ffd6df960af2c44dbe8de14f99241b1071";
    private static String webHook;

    public static String getWebHook() {
        return webHook;
    }

    public static void setWebHook(String webHook) {
        DingdingTalkUtils.webHook = webHook;
    }

    private static void doRequest(OapiRobotSendRequest request) {
        String hook = webHook;
        if (hook == null || !hook.contains("https://oapi.dingtalk.com/robot/send?access_token=")) {
            hook = DEFAULT_WEB_HOOK;
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient(hook);
        OapiRobotSendResponse response = null;
        try {
            response = (OapiRobotSendResponse)client.execute((TaobaoRequest)request);
            logger.info(response.toString());
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
    }

    private static void doRequest(OapiRobotSendRequest request, String url) {
        DefaultDingTalkClient client = new DefaultDingTalkClient(url);
        OapiRobotSendResponse response = null;
        try {
            response = (OapiRobotSendResponse)client.execute((TaobaoRequest)request);
            logger.info(response.toString());
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
    }

    public static void sendText(String message) {
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("text");
        OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
        text.setContent(message);
        request.setText(text);
        DingdingTalkUtils.doRequest(request);
    }

    public static void sendText(String url, String message) {
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("text");
        OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
        text.setContent(message);
        request.setText(text);
        DingdingTalkUtils.doRequest(request, url);
    }

    public static void sendText(String message, List<String> atMobiles) {
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("text");
        OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
        text.setContent(message);
        request.setText(text);
        OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
        at.setAtMobiles(atMobiles);
        request.setAt(at);
        DingdingTalkUtils.doRequest(request);
    }

    public static void sendLink(String msgUrl, String picUrl, String title, String text) {
        picUrl = picUrl == null ? "" : picUrl;
        title = title == null ? "" : title;
        text = text == null ? "" : text;
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("link");
        OapiRobotSendRequest.Link link = new OapiRobotSendRequest.Link();
        link.setMessageUrl(msgUrl);
        link.setPicUrl(picUrl);
        link.setTitle(title);
        link.setText(text);
        request.setLink(link);
        DingdingTalkUtils.doRequest(request);
    }

    public static void sendMarkdown(String title, String text) {
        text = text == null ? "" : text;
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("markdown");
        OapiRobotSendRequest.Markdown markdown = new OapiRobotSendRequest.Markdown();
        markdown.setTitle(title);
        markdown.setText(text);
        request.setMarkdown(markdown);
        DingdingTalkUtils.doRequest(request);
    }
}

