package com.xforceplus.route.api;

import com.xforceplus.route.api.common.Uri;
import com.xforceplus.route.api.common.response.ResponseEntity;
import com.xforceplus.domain.route.RouteDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author geewit
 */
public interface RouteApi {
    interface Path extends Uri {
        String PATH_GLOBAL = "/global";
        String PAGE = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/route/page";
        String LIST = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/route";
        String CREATE = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/route";
        String UPDATE = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/route/{id}";
        String DELETE = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/route/{id}";
    }

    @ResponseBody
    @RequestMapping(name = "路由分页列表", value = Path.PAGE, method = RequestMethod.GET)
    <T extends RouteDto> ResponseEntity<Page<T>> page(Pageable pageable);

    @ResponseBody
    @RequestMapping(name = "路由列表", value = Path.LIST, method = RequestMethod.GET)
    <T extends RouteDto> ResponseEntity<List<T>> list(Sort sort);

    @ResponseBody
    @RequestMapping(name = "新增路由", value = Path.CREATE, method = RequestMethod.POST)
    <T extends RouteDto> ResponseEntity<T> create(@RequestBody T route);

    @ResponseBody
    @RequestMapping(name = "更新路由", value = Path.UPDATE, method = RequestMethod.PUT)
    <T extends RouteDto> ResponseEntity<T> update(@PathVariable("id") Long id, @RequestBody T route);

    @ResponseBody
    @RequestMapping(name = "删除路由", value = Path.DELETE, method = RequestMethod.DELETE)
    ResponseEntity<String> delete(@PathVariable("id") Long id);
}
