package com.xforceplus.route.api;

import com.xforceplus.route.api.common.Uri;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import com.xforceplus.route.api.common.response.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;
import java.util.Set;

/**
 * @author geewit
 */
public interface ServiceApiApi {
    interface Path extends Uri {
        String PATH_GLOBAL = "/global";
        String LIST = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/service-apis/list";
    }

    @ResponseBody
    @RequestMapping(name = "服务包接口列表", value = Path.LIST, method = RequestMethod.GET)
    ResponseEntity<Map<Long, Set<ServiceApiModel.Response.ServiceApiWithResource>>> list();
}
