package com.xforceplus.saasnotifierservice.controller;


/**
 * 公司税务基本信息feign客户端
 *
 * @author ultraman
 * @date 2024-12-02
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.CompanyBaseInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "saas-notifier-service")
public interface CompanyBaseInfoFeignApi {

  /**
   * 通过id查询公司税务基本信息
   * @param  id
   * @return R
   */
  @GetMapping("/companyBaseInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增公司税务基本信息
   * @param companyBaseInfo 公司税务基本信息
   * @return R
   */
  @PostMapping("/companyBaseInfo/add")
  public R save(@RequestBody CompanyBaseInfo companyBaseInfo);

  /**
   * 修改公司税务基本信息
   * @param companyBaseInfo 公司税务基本信息
   * @return R
   */
  @PostMapping("/companyBaseInfo/update")
  public R updateById(@RequestBody CompanyBaseInfo companyBaseInfo);

  /**
   * 通过id删除公司税务基本信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/companyBaseInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}