package com.xforceplus.saasnotifierservice.controller;


/**
 * 风险预警规则feign客户端
 *
 * @author ultraman
 * @date 2024-12-02
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.RiskWarningRule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "saas-notifier-service")
public interface RiskWarningRuleFeignApi {

  /**
   * 通过id查询风险预警规则
   * @param  id
   * @return R
   */
  @GetMapping("/riskWarningRule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增风险预警规则
   * @param riskWarningRule 风险预警规则
   * @return R
   */
  @PostMapping("/riskWarningRule/add")
  public R save(@RequestBody RiskWarningRule riskWarningRule);

  /**
   * 修改风险预警规则
   * @param riskWarningRule 风险预警规则
   * @return R
   */
  @PostMapping("/riskWarningRule/update")
  public R updateById(@RequestBody RiskWarningRule riskWarningRule);

  /**
   * 通过id删除风险预警规则
   * @param  id
   * @return R
   */
  @DeleteMapping("/riskWarningRule/del/{id}" )
  public R removeById(@PathVariable Long id);

}