package com.xforceplus.saasnotifierservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * org_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-15
 */
public enum OrgType {

    COMPANY("company", "税号"),
    ORGNIZATION("orgnization", "组织");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OrgType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrgType fromCode(String code){
        switch(code) {
            case "company":
                return COMPANY;
            case "orgnization":
                return ORGNIZATION;
            default:
                return null;
        }
    }
}
