package com.xforceplus.saasnotifierservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * confirm_type
 * </p>
 *
 * @author ultraman
 * @since 2024-09-13
 */
public enum ConfirmType {

    _1("1", "撤销勾选"),
    _2("2", "撤销签名"),
    _3("3", "供应商异常操作");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ConfirmType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfirmType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
