package com.xforceplus.saasnotifierservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * missing_invoice_warning_rule_type
 * </p>
 *
 * @author ultraman
 * @since 2024-09-13
 */
public enum MissingInvoiceWarningRuleType {

    _1("1", "发票未获取底账提醒"),
    _2("2", "数电税号掉线提醒");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MissingInvoiceWarningRuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MissingInvoiceWarningRuleType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
