package com.xforceplus.saasnotifierservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * total_amount_warning_type
 * </p>
 *
 * @author ultraman
 * @since 2024-09-13
 */
public enum TotalAmountWarningType {

    _1("1", "季度开票金额预警"),
    _2("2", "连续12个月开票金额预警");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TotalAmountWarningType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TotalAmountWarningType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
