package com.xforceplus.saasnotifierservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * missing_invoice_warning_rule_notify_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-08
 */
public enum MissingInvoiceWarningRuleNotifyType {

    _1("1", "微信公众号"),
    _2("2", "钉钉"),
    _3("3", "邮箱");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MissingInvoiceWarningRuleNotifyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MissingInvoiceWarningRuleNotifyType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
