package com.xforceplus.saasnotifierservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * notify_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-08
 */
public enum NotifyType {

    EMAIL("email", " 邮件"),
    SMS("sms", " 短信"),
    FEISHU("feishu", "飞书");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NotifyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NotifyType fromCode(String code){
        switch(code) {
            case "email":
                return EMAIL;
            case "sms":
                return SMS;
            case "feishu":
                return FEISHU;
            default:
                return null;
        }
    }
}
